/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleRef;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.service.dao.GetModuleRefData;
import com.northernwall.hadrian.handlers.service.dao.GetNotUsesData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ServiceNotUsesGetHandler
extends AbstractHandler {
    private final DataAccess dataAccess;
    private final Gson gson;

    public ServiceNotUsesGetHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String serviceId = request.getParameter("serviceId");
        String moduleId = request.getParameter("moduleId");
        List<ModuleRef> refs = this.dataAccess.getModuleRefsByClient(serviceId, moduleId);
        GetNotUsesData notUses = new GetNotUsesData();
        List<Service> services = this.dataAccess.getActiveServices();
        for (Service service : services) {
            List<Module> modules = this.dataAccess.getModules(service.getServiceId());
            for (Module module : modules) {
                if (!this.checkModule(serviceId, moduleId, refs, module)) continue;
                GetModuleRefData ref = new GetModuleRefData();
                ref.serverServiceId = service.getServiceId();
                ref.serverModuleId = module.getModuleId();
                ref.serviceName = service.getServiceName();
                ref.moduleName = module.getModuleName();
                notUses.refs.add(ref);
            }
        }
        Collections.sort(notUses.refs, new Comparator<GetModuleRefData>(){

            @Override
            public int compare(GetModuleRefData o1, GetModuleRefData o2) {
                return o1.moduleName.compareTo(o2.moduleName);
            }
        });
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)notUses, GetNotUsesData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    private boolean checkModule(String serviceId, String moduleId, List<ModuleRef> refs, Module module) {
        if (module.getServiceId().equals(serviceId) && module.getModuleId().equals(moduleId)) {
            return false;
        }
        if (module.getModuleType().equals((Object)ModuleType.Test)) {
            return false;
        }
        for (ModuleRef ref : refs) {
            if (!module.getServiceId().equals(ref.getServerServiceId()) || !module.getModuleId().equals(ref.getServerModuleId())) continue;
            return false;
        }
        return true;
    }
}

