/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PutServiceData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceModifyHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public ServiceModifyHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutServiceData putServiceData = this.fromJson(request, PutServiceData.class);
        Service service = this.getService(putServiceData.serviceId, null);
        this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "modify a service");
        service.setServiceName(putServiceData.serviceName);
        service.setDescription(putServiceData.description);
        this.getDataAccess().updateService(service);
        response.setStatus(200);
        request.setHandled(true);
    }
}

