/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.GitMode;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PostServiceData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http405NotAllowedException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCreateHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceCreateHandler.class);
    private final AccessHelper accessHelper;

    public ServiceCreateHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostServiceData data = this.fromJson(request, PostServiceData.class);
        if (data.teamId == null || data.teamId.isEmpty()) {
            throw new Http400BadRequestException("teamId attribute is mising");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, data.teamId, "create a service");
        if (data.serviceName == null || data.serviceName.isEmpty()) {
            throw new Http400BadRequestException("Service Name is mising or empty");
        }
        if (data.serviceName.length() > 30) {
            throw new Http400BadRequestException("Service Name is to long, max is 30");
        }
        if (data.description.length() > 500) {
            throw new Http400BadRequestException("Description is to long, max is 500");
        }
        for (Service temp : Service.filterTeam(data.teamId, this.getDataAccess().getActiveServices())) {
            if (!temp.getServiceName().equalsIgnoreCase(data.serviceName) || !temp.isActive()) continue;
            throw new Http405NotAllowedException("A service already exists with that name, " + data.serviceName);
        }
        if (data.serviceType.equals("Shared Library")) {
            data.gitMode = GitMode.Flat;
        }
        if (data.gitMode == GitMode.Flat) {
            data.gitProject = null;
        } else {
            if (data.gitProject == null || data.gitProject.isEmpty()) {
                throw new Http400BadRequestException("Git Project is mising or empty");
            }
            if (data.gitProject.length() > 30) {
                throw new Http400BadRequestException("Git Project is to long, max is 30");
            }
        }
        Service service = new Service(data.serviceName, data.teamId, data.description, data.serviceType, data.gitMode, data.gitProject, true);
        this.getDataAccess().saveService(service);
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put("Name", service.getServiceName());
        this.createAudit(service.getServiceId(), user.getUsername(), Type.service, Operation.create, notes);
        response.setStatus(200);
        request.setHandled(true);
    }

    private void createAudit(String serviceId, String requestor, Type type, Operation operation, Map<String, String> notes) {
        Audit audit = new Audit();
        audit.serviceId = serviceId;
        audit.timePerformed = GMT.getGmtAsDate();
        audit.timeRequested = GMT.getGmtAsDate();
        audit.requestor = requestor;
        audit.type = type;
        audit.operation = operation;
        audit.successfull = true;
        audit.notes = ServiceCreateHandler.getGson().toJson(notes);
        this.getDataAccess().saveAudit(audit, null);
    }
}

