/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.ModuleCreateHandler;
import com.northernwall.hadrian.handlers.service.dao.PutModuleData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleModifyHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(ModuleModifyHandler.class);
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcess;

    public ModuleModifyHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutModuleData data = this.fromJson(request, PutModuleData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "update module");
        List<Host> hosts = this.getDataAccess().getHosts(data.serviceId);
        for (Host host : hosts) {
            Boolean temp;
            if (!host.getModuleId().equals(data.moduleId) || (temp = data.networkNames.get(host.getNetwork())) != null && temp.booleanValue()) continue;
            throw new Http400BadRequestException("Can not remove a network from a module with an active host");
        }
        List<Vip> vips = this.getDataAccess().getVips(data.serviceId);
        for (Vip vip : vips) {
            Boolean temp;
            if (!vip.getModuleId().equals(data.moduleId) || (temp = data.networkNames.get(vip.getNetwork())) != null && temp.booleanValue()) continue;
            throw new Http400BadRequestException("Can not remove a network from a module with an active VIP");
        }
        List<Module> list = this.getDataAccess().getModules(data.serviceId);
        LinkedList<Module> zeroModules = new LinkedList<Module>();
        Module module = null;
        for (Module temp : list) {
            if (temp.getModuleId().equals(data.moduleId)) {
                module = temp;
            }
            if (temp.getOrder() != 0) continue;
            zeroModules.add(temp);
        }
        if (module == null) {
            logger.warn("Could not find module with id {} in service {}", (Object)data.moduleId, (Object)data.serviceId);
            return;
        }
        list.removeAll(zeroModules);
        Collections.sort(list);
        if (data.order < 0) {
            data.order = 0;
        }
        if (data.order > list.size()) {
            data.order = list.size();
        }
        if (module.getModuleType().equals((Object)ModuleType.Library)) {
            data.hostAbbr = "";
            data.hostname = "";
            data.versionUrl = "";
            data.availabilityUrl = "";
            data.runAs = "";
            data.deploymentFolder = "";
            data.dataFolder = "";
            data.logsFolder = "";
            data.startCmdLine = "";
            data.startTimeOut = 0;
            data.stopCmdLine = "";
            data.stopTimeOut = 0;
        } else if (module.getModuleType().equals((Object)ModuleType.Test)) {
            data.hostAbbr = "";
            data.mavenGroupId = "";
            data.mavenArtifactId = "";
            data.artifactSuffix = "";
            data.versionUrl = "";
            data.availabilityUrl = "";
            data.dataFolder = "";
            data.logsFolder = "";
            data.stopCmdLine = "";
            data.stopTimeOut = 0;
            if (data.hostname == null || data.hostname.isEmpty()) {
                throw new Http400BadRequestException("Can not have an empty hostname");
            }
        } else {
            data.hostname = "";
            if (data.hostAbbr.contains("-")) {
                throw new Http400BadRequestException("Can not have '-' in host abbr");
            }
            data.deploymentFolder = ModuleCreateHandler.scrubFolder(data.deploymentFolder, "deploy", false);
            data.logsFolder = ModuleCreateHandler.scrubFolder(data.logsFolder, "logs", false);
            if (ModuleCreateHandler.isSubFolder(data.logsFolder, data.deploymentFolder)) {
                throw new Http400BadRequestException("Log folder can not be a sub folder of the deployment folder");
            }
            data.dataFolder = ModuleCreateHandler.scrubFolder(data.dataFolder, "data", true);
            if (data.dataFolder != null && ModuleCreateHandler.isSubFolder(data.dataFolder, data.deploymentFolder)) {
                throw new Http400BadRequestException("Data folder can not be a sub folder of the deployment folder");
            }
        }
        module.setModuleName(data.moduleName);
        module.setMavenGroupId(data.mavenGroupId);
        module.setMavenArtifactId(data.mavenArtifactId);
        module.setArtifactType(data.artifactType);
        module.setArtifactSuffix(data.artifactSuffix);
        module.setHostAbbr(data.hostAbbr.toLowerCase());
        module.setHostname(data.hostname);
        module.setVersionUrl(data.versionUrl);
        module.setAvailabilityUrl(data.availabilityUrl);
        module.setRunAs(data.runAs);
        module.setDeploymentFolder(data.deploymentFolder);
        module.setDataFolder(data.dataFolder);
        module.setLogsFolder(data.logsFolder);
        module.setLogsRetention(data.logsRetention);
        module.setStartCmdLine(data.startCmdLine);
        module.setStartTimeOut(data.startTimeOut);
        module.setStopCmdLine(data.stopCmdLine);
        module.setStopTimeOut(data.stopTimeOut);
        module.setConfigName(data.configName);
        module.setNetworkNames(data.networkNames);
        module.cleanNetworkNames(null);
        if (module.getOrder() != data.order) {
            if (module.getOrder() > 0) {
                list.remove(module);
            } else {
                zeroModules.remove(module);
            }
            module.setOrder(data.order);
            if (data.order > 0) {
                list.add(data.order - 1, module);
            } else {
                zeroModules.add(module);
            }
            int i = 1;
            for (Module temp : list) {
                if (temp.getOrder() != i) {
                    temp.setOrder(i);
                    this.getDataAccess().saveModule(temp);
                }
                ++i;
            }
        }
        this.getDataAccess().saveModule(module);
        WorkItem workItem = new WorkItem(Type.module, Operation.update, user, team, service, module, null, null);
        for (Module temp : zeroModules) {
            workItem.addModule(temp);
        }
        for (Module temp : list) {
            workItem.addModule(temp);
        }
        this.getDataAccess().saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }
}

