/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleRef;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.DeleteModuleData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ModuleDeleteHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcess;

    public ModuleDeleteHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        DeleteModuleData data = this.fromJson(request, DeleteModuleData.class);
        Service service = this.getService(data.serviceId, null);
        Module module = this.getModule(data.moduleId, null, service);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "deleting a module");
        for (Host host : this.getDataAccess().getHosts(data.serviceId)) {
            if (!host.getModuleId().equals(data.moduleId)) continue;
            throw new Http400BadRequestException("Can not delete module with an active host");
        }
        for (Vip vip : this.getDataAccess().getVips(data.serviceId)) {
            if (!vip.getModuleId().equals(data.moduleId)) continue;
            throw new Http400BadRequestException("Can not delete module with an active vip");
        }
        List<ModuleRef> refs = this.getDataAccess().getModuleRefsByClient(data.serviceId, data.moduleId);
        if (refs != null && !refs.isEmpty()) {
            throw new Http400BadRequestException("Can not delete a module which uses another module");
        }
        refs = this.getDataAccess().getModuleRefsByServer(data.serviceId, data.moduleId);
        if (refs != null && !refs.isEmpty()) {
            throw new Http400BadRequestException("Can not delete a module which is being used by anoter module");
        }
        List<Module> modules = this.getDataAccess().getModules(data.serviceId);
        Collections.sort(modules);
        modules.remove(module.getOrder() - 1);
        int i = 1;
        for (Module temp : modules) {
            if (temp.getOrder() != i) {
                temp.setOrder(i);
                this.getDataAccess().saveModule(temp);
            }
            ++i;
        }
        this.getDataAccess().deleteModule(data.serviceId, data.moduleId);
        WorkItem workItem = new WorkItem(Type.module, Operation.delete, user, team, service, module, null, null);
        for (Module temp : modules) {
            workItem.addModule(temp);
        }
        this.getDataAccess().saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }
}

