/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.GitMode;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PostModuleData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleCreateHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(ModuleCreateHandler.class);
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;
    private final WorkItemProcessor workItemProcess;

    public ModuleCreateHandler(AccessHelper accessHelper, ConfigHelper configHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostModuleData data = this.fromJson(request, PostModuleData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "add a module");
        Config config = this.configHelper.getConfig();
        String template = null;
        switch (data.moduleType) {
            case Deployable: {
                if (!config.deployableTemplates.contains(data.deployableTemplate)) {
                    throw new Http400BadRequestException("Unknown deployable template");
                }
                template = data.deployableTemplate;
                break;
            }
            case Library: {
                if (!config.libraryTemplates.contains(data.libraryTemplate)) {
                    throw new Http400BadRequestException("Unknown library template");
                }
                template = data.libraryTemplate;
                break;
            }
            case Simulator: {
                if (!config.deployableTemplates.contains(data.deployableTemplate)) {
                    throw new Http400BadRequestException("Unknown Simulator template");
                }
                template = data.deployableTemplate;
                break;
            }
            case Test: {
                if (!config.testTemplates.contains(data.testTemplate)) {
                    throw new Http400BadRequestException("Unknown test template");
                }
                template = data.testTemplate;
            }
        }
        if (!config.artifactTypes.contains(data.artifactType)) {
            throw new Http400BadRequestException("Unknown artifact");
        }
        if (service.getServiceType().equals("Shared Library")) {
            data.moduleType = ModuleType.Library;
        }
        if (data.moduleType.equals((Object)ModuleType.Library)) {
            data.hostAbbr = "";
            data.hostname = "";
            data.versionUrl = "";
            data.availabilityUrl = "";
            data.runAs = "";
            data.deploymentFolder = "";
            data.dataFolder = "";
            data.logsFolder = "";
            data.startCmdLine = "";
            data.startTimeOut = 0;
            data.stopCmdLine = "";
            data.stopTimeOut = 0;
        } else if (data.moduleType.equals((Object)ModuleType.Test)) {
            data.hostAbbr = "";
            data.mavenGroupId = "";
            data.mavenArtifactId = "";
            data.artifactSuffix = "";
            data.versionUrl = "";
            data.availabilityUrl = "";
            data.deploymentFolder = ModuleCreateHandler.scrubFolder(data.deploymentFolder, "deploy", false);
            data.dataFolder = "";
            data.logsFolder = "";
            data.stopCmdLine = "";
            data.stopTimeOut = 0;
            if (data.hostname == null || data.hostname.isEmpty()) {
                throw new Http400BadRequestException("Can not have an empty hostname");
            }
        } else {
            data.hostname = "";
            if (data.hostAbbr.contains("-")) {
                throw new Http400BadRequestException("Can not have '-' in host abbr");
            }
            data.deploymentFolder = ModuleCreateHandler.scrubFolder(data.deploymentFolder, "deploy", false);
            data.logsFolder = ModuleCreateHandler.scrubFolder(data.logsFolder, "logs", false);
            if (ModuleCreateHandler.isSubFolder(data.logsFolder, data.deploymentFolder)) {
                throw new Http400BadRequestException("Log folder can not be a sub folder of the deployment folder");
            }
            data.dataFolder = ModuleCreateHandler.scrubFolder(data.dataFolder, "data", true);
            if (data.dataFolder != null && ModuleCreateHandler.isSubFolder(data.dataFolder, data.deploymentFolder)) {
                throw new Http400BadRequestException("Data folder can not be a sub folder of the deployment folder");
            }
        }
        if (service.getGitMode().equals((Object)GitMode.Consolidated)) {
            data.gitProject = service.getGitProject();
            if (data.gitFolder == null) {
                data.gitFolder = "";
            }
            if (data.gitFolder.startsWith("/")) {
                data.gitFolder = data.gitFolder.substring(1);
            }
            if (data.gitFolder.endsWith(".")) {
                data.gitFolder = data.gitFolder.substring(0, data.gitFolder.length() - 1);
            }
            if (data.gitFolder.endsWith("/")) {
                data.gitFolder = data.gitFolder.substring(0, data.gitFolder.length() - 1);
            }
        } else {
            data.gitFolder = "";
        }
        List<Module> modules = this.getDataAccess().getModules(data.serviceId);
        LinkedList<Module> zeroModules = new LinkedList<Module>();
        for (Module temp : modules) {
            if (data.moduleName.equalsIgnoreCase(temp.getModuleName())) {
                throw new Http400BadRequestException("Error there already exists a module named " + data.moduleName + " on service " + data.serviceId);
            }
            if (data.gitProject.equalsIgnoreCase(temp.getGitProject())) {
                String tempGitFolder;
                String gitFolder = "/" + data.gitFolder.toUpperCase() + "/";
                if (gitFolder.equals(tempGitFolder = "/" + temp.getGitFolder().toUpperCase() + "/")) {
                    throw new Http400BadRequestException("Error there already exists a module with git project " + data.gitProject + " and folder " + data.gitFolder + " on service " + data.serviceId);
                }
                if (gitFolder.startsWith(tempGitFolder)) {
                    throw new Http400BadRequestException("A Module's git folder may not be a sub folder of another module");
                }
                if (tempGitFolder.startsWith(gitFolder)) {
                    throw new Http400BadRequestException("A Module's git folder may not be a sub folder of another module");
                }
            }
            if (temp.getOrder() != 0) continue;
            zeroModules.add(temp);
        }
        modules.removeAll(zeroModules);
        Collections.sort(modules);
        if (data.order < 0) {
            data.order = 0;
        }
        if (data.order > 0) {
            if (data.order > modules.size() + 1) {
                data.order = modules.size() + 1;
            }
            for (Module temp : modules) {
                if (temp.getOrder() < data.order) continue;
                temp.setOrder(temp.getOrder() + 1);
                this.getDataAccess().updateModule(temp);
            }
        }
        Module module = new Module(data.moduleName, data.serviceId, data.order, data.moduleType, data.gitProject, data.gitFolder, data.mavenGroupId, data.mavenArtifactId, data.artifactType, data.artifactSuffix, data.hostAbbr.toLowerCase(), data.hostname, data.versionUrl, data.availabilityUrl, data.runAs, data.deploymentFolder, data.dataFolder, data.logsFolder, data.logsRetention, data.startCmdLine, data.startTimeOut, data.stopCmdLine, data.stopTimeOut, data.configName, data.networkNames);
        module.cleanNetworkNames(null);
        this.getDataAccess().saveModule(module);
        if (module.getOrder() > 0) {
            modules.add(module.getOrder() - 1, module);
        } else {
            zeroModules.add(module);
        }
        WorkItem workItem = new WorkItem(Type.module, Operation.create, user, team, service, module, null, null);
        workItem.getMainModule().template = template;
        for (Module temp : zeroModules) {
            workItem.addModule(temp);
        }
        for (Module temp : modules) {
            workItem.addModule(temp);
        }
        this.getDataAccess().saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }

    public static String scrubFolder(String folder, String name, boolean nullAllowed) {
        if (folder == null || folder.isEmpty()) {
            if (nullAllowed) {
                return null;
            }
            throw new Http400BadRequestException("Folder " + name + " can not be null or empty");
        }
        String temp = folder.trim();
        if (temp == null || temp.isEmpty()) {
            if (nullAllowed) {
                return null;
            }
            throw new Http400BadRequestException("Folder " + name + " can not be null or empty");
        }
        if (temp.equals("/")) {
            throw new Http400BadRequestException("Folder " + name + " can not be root");
        }
        if (!folder.startsWith("/")) {
            temp = "/" + temp;
        }
        if (temp.endsWith("/") && temp.length() > 1) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }

    public static boolean isSubFolder(String subFolder, String mainFolder) {
        String tempMainFolder;
        String tempSubFolder = subFolder;
        if (tempSubFolder.length() > 1) {
            tempSubFolder = tempSubFolder + "/";
        }
        if ((tempMainFolder = mainFolder).length() > 1) {
            tempMainFolder = tempMainFolder + "/";
        }
        return tempSubFolder.equals(tempMainFolder) || tempSubFolder.startsWith(tempMainFolder);
    }
}

