/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.details.HostDetailsHelper;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.FindHostData;
import com.northernwall.hadrian.handlers.service.helper.InfoHelper;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http404NotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class HostFindHandler
extends BasicHandler {
    private final InfoHelper infoHelper;
    private final HostDetailsHelper hostDetailsHelper;

    public HostFindHandler(DataAccess dataAccess, InfoHelper infoHelper, HostDetailsHelper hostDetailsHelper) {
        super(dataAccess);
        this.infoHelper = infoHelper;
        this.hostDetailsHelper = hostDetailsHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String hostName = request.getParameter("hostName");
        if (hostName == null || hostName.isEmpty()) {
            throw new Http400BadRequestException("hostName is empty");
        }
        Host host = this.getDataAccess().getHost(hostName);
        if (host == null) {
            throw new Http404NotFoundException("Could not find host " + hostName);
        }
        Service service = this.getDataAccess().getService(host.getServiceId());
        if (service == null) {
            throw new Http404NotFoundException("Could not find service for host " + hostName);
        }
        Module module = this.getDataAccess().getModule(host.getServiceId(), host.getModuleId());
        if (module == null) {
            throw new Http404NotFoundException("Could not find module host " + hostName);
        }
        Team team = this.getDataAccess().getTeam(service.getTeamId());
        if (module == null) {
            throw new Http404NotFoundException("Could not find team host " + hostName);
        }
        FindHostData findHostData = new FindHostData();
        findHostData.teamId = team.getTeamId();
        findHostData.teamName = team.getTeamName();
        findHostData.serviceId = service.getServiceId();
        findHostData.serviceName = service.getServiceName();
        findHostData.moduleId = module.getModuleId();
        findHostData.moduleName = module.getModuleName();
        findHostData.hostId = host.getHostId();
        findHostData.hostName = host.getHostName();
        findHostData.status = host.getStatus();
        findHostData.busy = host.isBusy();
        findHostData.dataCenter = host.getDataCenter();
        findHostData.network = host.getNetwork();
        findHostData.env = host.getEnv();
        findHostData.version = this.infoHelper.readVersion(hostName, module.getVersionUrl());
        findHostData.availability = this.infoHelper.readAvailability(hostName, module.getAvailabilityUrl());
        findHostData.details = this.hostDetailsHelper.getDetails(host);
        response.setContentType("application/json; charset=utf-8");
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            HostFindHandler.getGson().toJson((Object)findHostData, FindHostData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

