/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Network;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PutDeploySoftwareData;
import com.northernwall.hadrian.handlers.service.helper.InfoHelper;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDeploySoftwareHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(HostDeploySoftwareHandler.class);
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;
    private final InfoHelper infoHelper;
    private final WorkItemProcessor workItemProcess;

    public HostDeploySoftwareHandler(AccessHelper accessHelper, ConfigHelper configHelper, InfoHelper infoHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
        this.infoHelper = infoHelper;
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutDeploySoftwareData data = this.fromJson(request, PutDeploySoftwareData.class);
        Service service = this.getService(data.serviceId, data.serviceName);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanDeploy(request, service.getTeamId());
        Module module = this.getModule(data.moduleId, data.moduleName, service);
        Network network = null;
        for (Network temp : this.configHelper.getConfig().networks) {
            if (!temp.name.equals(data.network)) continue;
            network = temp;
        }
        if (network == null) {
            throw new Http400BadRequestException("Unknown network " + data.network);
        }
        if (!network.allowUrl && data.versionUrl != null) {
            throw new Http400BadRequestException("Network " + network.name + " does not allow versionUrl");
        }
        if (data.version != null && data.versionUrl != null) {
            throw new Http400BadRequestException("Only one of version and versionUrl can be specified");
        }
        if ((data.version == null || data.version.isEmpty()) && (data.versionUrl == null || data.versionUrl.isEmpty())) {
            throw new Http400BadRequestException("One of version and versionUrl must be specified");
        }
        List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(hosts.size());
        for (Host host : hosts) {
            if (!host.getModuleId().equals(module.getModuleId()) || !host.getNetwork().equals(data.network) || !data.all && !data.hostNames.contains(host.getHostName()) || host.isBusy()) continue;
            WorkItem workItem = new WorkItem(Type.host, Operation.deploy, user, team, service, module, host, null);
            workItem.getHost().version = data.version;
            workItem.getHost().prevVersion = this.infoHelper.readVersion(host.getHostName(), module.getVersionUrl());
            workItem.getHost().versionUrl = data.versionUrl;
            workItem.getHost().configVersion = data.configVersion;
            workItem.getHost().reason = data.reason;
            if (workItems.isEmpty()) {
                host.setStatus(true, "Deploying...");
            } else {
                host.setStatus(true, "Deploy Queued");
            }
            this.getDataAccess().updateHost(host);
            workItems.add(workItem);
        }
        String prevId = null;
        int size = workItems.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                WorkItem workItem = (WorkItem)workItems.get(size - i - 1);
                workItem.setNextId(prevId);
                prevId = workItem.getId();
                this.getDataAccess().saveWorkItem(workItem);
            }
            this.workItemProcess.sendWorkItem((WorkItem)workItems.get(0));
            if (data.wait) {
                logger.info("Waiting for deployment, {} {} {}", new Object[]{service.getServiceName(), module.getModuleName(), data.version});
                String lastId = ((WorkItem)workItems.get(size - 1)).getId();
                for (int i = 0; i < size * 2 * 10; ++i) {
                    try {
                        Thread.sleep(module.getStartTimeOut() * 100);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    int workItemStatus = this.getDataAccess().getWorkItemStatus(lastId);
                    if (workItemStatus <= 0) continue;
                    logger.info("Waiting done, status {}", (Object)workItemStatus);
                    response.setStatus(workItemStatus);
                    request.setHandled(true);
                    return;
                }
            }
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

