/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Network;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PostHostData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostCreateHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(HostCreateHandler.class);
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;
    private final WorkItemProcessor workItemProcess;

    public HostCreateHandler(AccessHelper accessHelper, ConfigHelper configHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
        this.workItemProcess = workItemProcess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostHostData data = this.fromJson(request, PostHostData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "add a host");
        if (data.count < 1) {
            throw new Http400BadRequestException("count must to at least 1");
        }
        if (data.count > 10) {
            logger.warn("Reducing count to 10, was {}", (Object)data.count);
            data.count = 10;
        }
        Config config = this.configHelper.getConfig();
        if (!config.dataCenters.contains(data.dataCenter)) {
            throw new Http400BadRequestException("Unknown data center");
        }
        if (!config.networkNames.contains(data.network)) {
            throw new Http400BadRequestException("Unknown network");
        }
        if (!config.envs.contains(data.env)) {
            throw new Http400BadRequestException("Unknown operating env");
        }
        Module module = this.getModule(data.moduleId, null, service);
        if (module.getModuleType() != ModuleType.Deployable && module.getModuleType() != ModuleType.Simulator) {
            throw new Http400BadRequestException("Module must be a deployable or simulator");
        }
        String prefix = this.buildPrefix(data.network, config, data.dataCenter, module.getHostAbbr());
        int len = prefix.length();
        int num = 0;
        List<Host> hosts = this.getDataAccess().getHosts(data.serviceId);
        for (Host existingHost : hosts) {
            String existingHostName = existingHost.getHostName();
            if (!existingHostName.startsWith(prefix) || existingHostName.length() <= len) continue;
            String numPart = existingHostName.substring(len);
            try {
                int temp = Integer.parseInt(numPart);
                if (temp <= num) continue;
                num = temp;
            }
            catch (Exception e) {
                logger.warn("Error parsing int from last part of {}", (Object)existingHostName);
            }
        }
        ++num;
        for (int c = 0; c < data.count; ++c) {
            String numStr = Integer.toString(num + c);
            numStr = "000".substring(numStr.length()) + numStr;
            Host host = new Host(prefix + numStr, data.serviceId, "Creating...", data.moduleId, data.dataCenter, data.network, data.env);
            this.getDataAccess().saveHost(host);
            WorkItem workItemCreate = new WorkItem(Type.host, Operation.create, user, team, service, module, host, null);
            WorkItem workItemDeploy = new WorkItem(Type.host, Operation.deploy, user, team, service, module, host, null);
            workItemCreate.getHost().sizeCpu = data.sizeCpu;
            workItemCreate.getHost().sizeMemory = data.sizeMemory;
            workItemCreate.getHost().sizeStorage = data.sizeStorage;
            workItemCreate.getHost().version = data.version;
            workItemCreate.getHost().configVersion = data.configVersion;
            workItemCreate.getHost().reason = data.reason;
            workItemCreate.setNextId(workItemDeploy.getId());
            workItemDeploy.getHost().version = data.version;
            workItemDeploy.getHost().configVersion = data.configVersion;
            workItemDeploy.getHost().reason = data.reason;
            this.getDataAccess().saveWorkItem(workItemCreate);
            this.getDataAccess().saveWorkItem(workItemDeploy);
            this.workItemProcess.sendWorkItem(workItemCreate);
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    private String buildPrefix(String networkName, Config config, String dataCenter, String abbr) {
        for (Network network : config.networks) {
            if (!network.name.equals(networkName)) continue;
            String prefix = network.pattern;
            prefix = prefix.replace("{dc}", dataCenter);
            prefix = prefix.replace("{abbr}", abbr);
            return prefix;
        }
        throw new Http400BadRequestException("Unknown network");
    }
}

