/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PostBackfillHostData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostBackfillHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(HostBackfillHandler.class);
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;

    public HostBackfillHandler(AccessHelper accessHelper, ConfigHelper configHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String[] hostnames;
        PostBackfillHostData data = this.fromJson(request, PostBackfillHostData.class);
        Service service = this.getService(data.serviceId, null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "backfill host");
        Config config = this.configHelper.getConfig();
        if (!config.dataCenters.contains(data.dataCenter)) {
            throw new Http400BadRequestException("unknown datacenter, " + data.dataCenter);
        }
        if (!config.networkNames.contains(data.network)) {
            throw new Http400BadRequestException("unknown network, " + data.network);
        }
        if (!config.envs.contains(data.env)) {
            throw new Http400BadRequestException("unknown operating env, " + data.env);
        }
        Module module = this.getModule(data.moduleId, null, service);
        if (module.getModuleType() != ModuleType.Deployable && module.getModuleType() != ModuleType.Simulator) {
            throw new Http400BadRequestException("Module must be a deployable or simulator");
        }
        List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
        for (String hostname : hostnames = data.hosts.split(",")) {
            String temp = HostBackfillHandler.scrubHostname(hostname);
            if (temp == null || temp.isEmpty()) continue;
            boolean found = false;
            for (Host host : hosts) {
                if (!host.getHostName().equalsIgnoreCase(temp)) continue;
                found = true;
            }
            if (found) continue;
            Host host = new Host(temp, service.getServiceId(), "-", module.getModuleId(), data.dataCenter, data.network, data.env);
            this.getDataAccess().saveHost(host);
            Audit audit = new Audit();
            audit.serviceId = service.getServiceId();
            audit.timePerformed = GMT.getGmtAsDate();
            audit.timeRequested = GMT.getGmtAsDate();
            audit.requestor = user.getUsername();
            audit.type = Type.host;
            audit.operation = Operation.create;
            audit.successfull = true;
            audit.moduleName = module.getModuleName();
            audit.hostName = temp;
            HashMap<String, String> notes = new HashMap<String, String>();
            notes.put("Reason", "Backfilled host.");
            notes.put("DC", data.dataCenter);
            notes.put("Network", data.network);
            notes.put("Operating_Env", data.env);
            audit.notes = HostBackfillHandler.getGson().toJson(notes);
            this.getDataAccess().saveAudit(audit, null);
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    public static String scrubHostname(String hostname) {
        if (hostname == null) {
            return null;
        }
        String temp = hostname.trim();
        if (temp == null || temp.isEmpty()) {
            return null;
        }
        int index = temp.indexOf(".");
        if (index == -1) {
            return temp;
        }
        if (index == 0) {
            return null;
        }
        if ((temp = temp.substring(0, index).trim()) == null || temp.isEmpty()) {
            return null;
        }
        return temp;
    }
}

