/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Document;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.DeleteDocumentData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class DocumentDeleteHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public DocumentDeleteHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        DeleteDocumentData data = this.fromJson(request, DeleteDocumentData.class);
        Service service = this.getService(data.serviceId, null);
        this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "remove document");
        Document doc = null;
        for (Document temp : service.getDocuments()) {
            if (!temp.getDocId().equals(data.docId)) continue;
            doc = temp;
        }
        if (doc != null) {
            service.getDocuments().remove(doc);
            this.getDataAccess().updateService(service);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

