/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PostCustomFunctionData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class CustomFuntionCreateHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public CustomFuntionCreateHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostCustomFunctionData postCFData = this.fromJson(request, PostCustomFunctionData.class);
        Service service = this.getService(postCFData.serviceId, null);
        this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "create custom function");
        CustomFunction customFunction = new CustomFunction(service.getServiceId(), postCFData.moduleId, postCFData.name, postCFData.method, postCFData.url, postCFData.teamOnly);
        this.getDataAccess().saveCustomFunction(customFunction);
        response.setStatus(200);
        request.setHandled(true);
    }
}

