/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.GetAuditData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditGetHandler
extends BasicHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuditGetHandler.class);

    public AuditGetHandler(DataAccess dataAccess) {
        super(dataAccess);
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String year = request.getParameter("year");
        String month = request.getParameter("month");
        String start = request.getParameter("start");
        String end = request.getParameter("end");
        String id = request.getParameter("serviceId");
        GetAuditData auditData = new GetAuditData();
        Service service = this.getService(request);
        if (year == null || year.isEmpty()) {
            throw new Http400BadRequestException("parameter year is missing");
        }
        if (month == null || month.isEmpty()) {
            throw new Http400BadRequestException("parameter month is missing");
        }
        if (start == null || start.isEmpty()) {
            throw new Http400BadRequestException("parameter start is missing");
        }
        if (end == null || end.isEmpty()) {
            throw new Http400BadRequestException("parameter end is missing");
        }
        auditData.audits = this.getDataAccess().getAudit(id, Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(start), Integer.parseInt(end));
        logger.info("Got {} audit record for {} between {} {} {} and {}", new Object[]{auditData.audits.size(), service.getServiceName(), year, month, start, end});
        Collections.sort(auditData.audits);
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            AuditGetHandler.getGson().toJson((Object)auditData, GetAuditData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

