/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.domain;

import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.workItem.dao.HostData;
import com.northernwall.hadrian.workItem.dao.ModuleData;
import com.northernwall.hadrian.workItem.dao.ServiceData;
import com.northernwall.hadrian.workItem.dao.TeamData;
import com.northernwall.hadrian.workItem.dao.VipData;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;

public class WorkItem {
    private String id = UUID.randomUUID().toString();
    private Type type;
    private Operation operation;
    private String nextId;
    private String username;
    private String fullname;
    private Date requestDate;
    private TeamData team;
    private ServiceData service;
    private ModuleData mainModule;
    private List<ModuleData> modules;
    private HostData host;
    private VipData vip;

    public WorkItem(Type type, Operation operation, User user, Team team, Service service, Module module, Host host, Vip vip) {
        this.type = type;
        this.operation = operation;
        this.nextId = null;
        this.username = user.getUsername();
        this.fullname = user.getFullName();
        this.requestDate = Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
        this.team = TeamData.create(team);
        this.service = ServiceData.create(service);
        this.mainModule = ModuleData.create(module);
        this.modules = new LinkedList<ModuleData>();
        this.host = HostData.create(host);
        this.vip = VipData.create(vip);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String getNextId() {
        return this.nextId;
    }

    public void setNextId(String nextId) {
        this.nextId = nextId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(Date requestDate) {
        this.requestDate = requestDate;
    }

    public TeamData getTeam() {
        return this.team;
    }

    public void setTeam(TeamData team) {
        this.team = team;
    }

    public ServiceData getService() {
        return this.service;
    }

    public void setService(ServiceData service) {
        this.service = service;
    }

    public ModuleData getMainModule() {
        return this.mainModule;
    }

    public void setMainModule(ModuleData module) {
        this.mainModule = module;
    }

    public void addModule(Module module) {
        this.modules.add(ModuleData.create(module));
    }

    public List<ModuleData> getModules() {
        return this.modules;
    }

    public HostData getHost() {
        return this.host;
    }

    public void setHost(HostData host) {
        this.host = host;
    }

    public VipData getVip() {
        return this.vip;
    }

    public void setVip(VipData vip) {
        this.vip = vip;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("WorkItem{id=");
        str.append(this.id);
        str.append(", type=");
        str.append((Object)this.type);
        str.append(", operation=");
        str.append((Object)this.operation);
        str.append(", nextId=");
        str.append(this.nextId);
        str.append(", username=");
        str.append(this.username);
        str.append(", fullname=");
        str.append(this.fullname);
        str.append(", requestDate=");
        str.append(this.requestDate);
        str.append(", team=");
        str.append(this.team);
        str.append(", service=");
        str.append(this.service);
        if (this.mainModule != null) {
            str.append(", mainModule=");
            str.append(this.mainModule.toString());
        }
        if (this.modules != null && !this.modules.isEmpty()) {
            str.append(", modules=[");
            for (ModuleData temp : this.modules) {
                str.append(temp.toString());
                str.append(",");
            }
            str.append("]");
        }
        if (this.host != null) {
            str.append(", host=");
            str.append(this.host);
        }
        if (this.vip != null) {
            str.append(", vip=");
            str.append(this.vip);
        }
        return str.toString();
    }
}

