/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.domain;

import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.domain.Document;
import com.northernwall.hadrian.domain.GitMode;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class Service
implements Comparable<Service> {
    private String serviceId = UUID.randomUUID().toString();
    private String serviceName;
    private String teamId;
    private String description;
    private String serviceType;
    private GitMode gitMode;
    private String gitProject;
    private List<Document> documents;
    private Date creationDate;
    private Date deletionDate;
    private boolean active = true;

    public Service(String serviceName, String teamId, String description, String serviceType, GitMode gitMode, String gitProject, boolean active) {
        this.serviceName = serviceName;
        this.teamId = teamId;
        this.description = description;
        this.serviceType = serviceType;
        this.gitMode = gitMode;
        this.gitProject = gitProject;
        this.documents = new LinkedList<Document>();
        this.creationDate = GMT.getGmtAsDate();
        this.deletionDate = null;
        this.active = active;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public GitMode getGitMode() {
        return this.gitMode;
    }

    public void setGitMode(GitMode gitMode) {
        this.gitMode = gitMode;
    }

    public String getGitProject() {
        return this.gitProject;
    }

    public void setGitProject(String gitProject) {
        this.gitProject = gitProject;
    }

    public List<Document> getDocuments() {
        if (this.documents == null) {
            this.documents = new LinkedList<Document>();
        }
        return this.documents;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getDeletionDate() {
        return this.deletionDate;
    }

    public void setDeletionDate(Date deletionDate) {
        this.deletionDate = deletionDate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int compareTo(Service o) {
        return this.serviceName.compareToIgnoreCase(o.serviceName);
    }

    public static List<Service> filterTeam(String teamId, List<Service> services) {
        LinkedList<Service> temp = new LinkedList<Service>();
        if (services != null && !services.isEmpty()) {
            for (Service service : services) {
                if (!service.getTeamId().equals(teamId)) continue;
                temp.add(service);
            }
        }
        return temp;
    }
}

