/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.details.simple;

import com.google.gson.Gson;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.details.VipDetailsHelper;
import com.northernwall.hadrian.details.simple.SimpleVipDetailsRunnable;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.handlers.service.dao.GetVipDetailsData;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.OkHttpClient;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;

public class SimpleVipDetailsHelper
implements VipDetailsHelper {
    private final OkHttpClient client;
    private final Parameters parameters;
    private final ConfigHelper configHelper;
    private final Gson gson;
    private final ExecutorService executorService;

    public SimpleVipDetailsHelper(OkHttpClient client, Parameters parameters, ConfigHelper configHelper) {
        this.client = client;
        this.parameters = parameters;
        this.configHelper = configHelper;
        this.gson = new Gson();
        this.executorService = Executors.newFixedThreadPool(20);
    }

    @Override
    public GetVipDetailsData getDetails(Vip vip) {
        String vipUrl = this.parameters.getString("vipDetailsHelper.vipDetailsUrl", null);
        String poolUrl = this.parameters.getString("vipDetailsHelper.poolDetailsUrl", null);
        if (vipUrl == null || vipUrl.isEmpty()) {
            return null;
        }
        vipUrl = vipUrl.replace("{vip}", vip.getDns());
        GetVipDetailsData data = new GetVipDetailsData();
        LinkedList<Future> futures = new LinkedList<Future>();
        for (String dataCenter : this.configHelper.getConfig().dataCenters) {
            futures.add(this.executorService.submit(new SimpleVipDetailsRunnable(this.gson, this.client, vip, data, vipUrl, poolUrl, dataCenter)));
        }
        this.waitForFutures(futures);
        return data;
    }

    protected void waitForFutures(List<Future> futures) {
        for (int i = 0; i < 151; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            futures.removeIf(new Predicate<Future>(){

                @Override
                public boolean test(Future t) {
                    return t.isDone();
                }
            });
            if (!futures.isEmpty()) continue;
            return;
        }
    }
}

