/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.details.simple;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.northernwall.hadrian.details.HostDetailsHelper;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.handlers.service.dao.GetHostDetailsData;
import com.northernwall.hadrian.handlers.service.dao.GetPairData;
import com.northernwall.hadrian.parameters.ParameterChangeListener;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHostDetailsHelper
implements HostDetailsHelper,
ParameterChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(HostDetailsHelper.class);
    private final OkHttpClient client;
    private final Parameters parameters;
    private final JsonParser parser;
    private final List<String> urlTemplates;
    private final List<String> attributes;

    public SimpleHostDetailsHelper(OkHttpClient client, Parameters parameters) {
        this.client = client;
        this.parameters = parameters;
        this.parser = new JsonParser();
        this.urlTemplates = new LinkedList<String>();
        this.attributes = new LinkedList<String>();
        this.load();
        parameters.registerChangeListener(this);
    }

    @Override
    public void onChange(List<String> keys) {
        this.load();
        logger.info("Reloading parameters.");
    }

    private void load() {
        String[] parts;
        String temp = this.parameters.getString("host.detailsUrl", null);
        this.urlTemplates.clear();
        if (temp != null && !temp.isEmpty()) {
            for (String part : parts = temp.split(",")) {
                if ((part = part.trim()).isEmpty()) continue;
                this.urlTemplates.add(part);
            }
        }
        temp = this.parameters.getString("host.detailsAttrs", null);
        this.attributes.clear();
        if (temp != null && !temp.isEmpty()) {
            for (String part : parts = temp.split(",")) {
                if ((part = part.trim()).isEmpty()) continue;
                this.attributes.add(part);
            }
        }
    }

    @Override
    public GetHostDetailsData getDetails(Host host) {
        LinkedList<GetPairData> pairs = new LinkedList<GetPairData>();
        if (!this.urlTemplates.isEmpty()) {
            for (String urlTemplate : this.urlTemplates) {
                String url = urlTemplate.replace("{host}", host.getHostName());
                this.getDetailsFromUrl(host, url, pairs);
            }
        }
        Collections.sort(pairs);
        GetHostDetailsData details = new GetHostDetailsData();
        for (GetPairData pair : pairs) {
            details.addPair(pair);
        }
        return details;
    }

    private void getDetailsFromUrl(Host host, String url, List<GetPairData> pairs) {
        Request httpRequest = new Request.Builder().url(url).build();
        try {
            Response resp = this.client.newCall(httpRequest).execute();
            try (InputStreamReader reader = new InputStreamReader(resp.body().byteStream());){
                if (resp.isSuccessful()) {
                    JsonElement jsonElement = this.parser.parse((Reader)reader);
                    if (jsonElement.isJsonObject()) {
                        JsonObject jsonObject = jsonElement.getAsJsonObject();
                        for (Map.Entry entry : jsonObject.entrySet()) {
                            this.processAttribute(null, entry, pairs);
                        }
                    }
                } else {
                    logger.warn("Call to {} failed with code {}", (Object)url, (Object)resp.code());
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Error while getting secondary host details for {}, error {}", (Object)host.getHostName(), (Object)ex.getMessage());
        }
    }

    private void processAttribute(String prefix, Map.Entry<String, JsonElement> entry, List<GetPairData> pairs) {
        if (entry.getValue().isJsonPrimitive()) {
            this.addPair(prefix, entry.getKey(), entry.getValue().getAsString(), pairs);
        } else if (entry.getValue().isJsonArray()) {
            StringBuffer buffer = null;
            JsonArray jsonArray = entry.getValue().getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement arrayElement = jsonArray.get(i);
                if (!arrayElement.isJsonPrimitive()) continue;
                if (buffer == null) {
                    buffer = new StringBuffer(arrayElement.getAsString());
                    continue;
                }
                buffer.append(", ");
                buffer.append(arrayElement.getAsString());
            }
            if (buffer != null) {
                this.addPair(prefix, entry.getKey(), buffer.toString(), pairs);
            }
        } else if (entry.getValue().isJsonObject()) {
            JsonObject jsonObject = entry.getValue().getAsJsonObject();
            for (Map.Entry innerEntry : jsonObject.entrySet()) {
                this.processAttribute(entry.getKey(), innerEntry, pairs);
            }
        }
    }

    private void addPair(String prefix, String label, String value, List<GetPairData> data) {
        if (label == null || label.isEmpty() || value == null || value.isEmpty()) {
            return;
        }
        if (prefix != null && !prefix.isEmpty()) {
            label = prefix + "_" + label;
        }
        if (this.attributes.isEmpty() || this.attributes.contains(label)) {
            label = label.replace("-", " ").replace("_", " ");
            data.add(new GetPairData(label, value));
        }
    }
}

