/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.access;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http401UnauthorizedException;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http404NotFoundException;
import java.util.List;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessHelper {
    private static final Logger logger = LoggerFactory.getLogger(AccessHelper.class);
    private final DataAccess dataAccess;

    public AccessHelper(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public User getUser(String username) {
        User user = this.dataAccess.getUser(username);
        if (user == null) {
            List<User> users = this.dataAccess.getUsers();
            if (users == null || users.isEmpty()) {
                logger.info("No users found. So creating {} as the first user", (Object)username);
                user = new User(username, username, true, false, false);
            } else {
                logger.info("User {} not found, creating", (Object)username);
                user = new User(username, username, false, false, false);
            }
            this.dataAccess.saveUser(user);
        }
        return user;
    }

    public boolean canUserModify(Request request, String teamId) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user");
        }
        Team team = this.dataAccess.getTeam(teamId);
        if (team == null) {
            throw new Http404NotFoundException("unknown team");
        }
        return team.getUsernames().contains(user.getUsername());
    }

    public User checkIfUserCanModify(Request request, String teamId, String action) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user attempted to " + action);
        }
        String username = user.getUsername();
        Team team = this.dataAccess.getTeam(teamId);
        if (team == null) {
            throw new Http404NotFoundException(username + " attempted to " + action + " on team " + teamId + " but could not find team");
        }
        if (!team.getUsernames().contains(username)) {
            throw new Http401UnauthorizedException(username + " attempted to " + action + " on team " + team.getTeamName());
        }
        return user;
    }

    public User checkIfUserCanDeploy(Request request, String teamId) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user attempted to deploy software to host");
        }
        if (user.isDeploy()) {
            return user;
        }
        String username = user.getUsername();
        Team team = this.dataAccess.getTeam(teamId);
        if (team == null) {
            throw new Http404NotFoundException(username + " attempted to deploy software to host on team " + teamId + " but could not find team");
        }
        if (!team.getUsernames().contains(username)) {
            throw new Http401UnauthorizedException(username + " attempted to deploy software to host on team " + team.getTeamName());
        }
        return user;
    }

    public User checkIfUserCanRestart(Request request, String teamId) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user attempted to restart host");
        }
        if (user.isDeploy() || user.isAdmin()) {
            return user;
        }
        String username = user.getUsername();
        Team team = this.dataAccess.getTeam(teamId);
        if (team == null) {
            throw new Http404NotFoundException(username + " attempted to restart host on team " + teamId + " but could not find team");
        }
        if (!team.getUsernames().contains(username)) {
            throw new Http401UnauthorizedException(username + " attempted to restart host on team " + team.getTeamName());
        }
        return user;
    }

    public User checkIfUserCanAudit(Request request, Team team) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user attempted to add audit record");
        }
        if (user.isAudit()) {
            return user;
        }
        String username = user.getUsername();
        if (!team.getUsernames().contains(username)) {
            throw new Http401UnauthorizedException(username + " attempted to add audit record on team " + team.getTeamName());
        }
        return user;
    }

    public User checkIfUserCanAudit(Request request, String teamId) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user attempted to add audit record");
        }
        if (user.isAudit()) {
            return user;
        }
        String username = user.getUsername();
        Team team = this.dataAccess.getTeam(teamId);
        if (team == null) {
            throw new Http404NotFoundException(username + " attempted to add audit record on team " + teamId + " but could not find team");
        }
        if (!team.getUsernames().contains(username)) {
            throw new Http401UnauthorizedException(username + " attempted to add audit record on team " + team.getTeamName());
        }
        return user;
    }

    public User checkIfUserIsAdmin(Request request, String action) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown users attempted to " + action + " but is not an admin");
        }
        if (!user.isAdmin()) {
            throw new Http401UnauthorizedException(user.getUsername() + " attempted to " + action + " but is not an admin");
        }
        return user;
    }
}

