/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.GitMode;
import com.northernwall.hadrian.domain.Network;
import com.northernwall.hadrian.module.ModuleArtifactHelper;
import com.northernwall.hadrian.module.ModuleConfigHelper;
import com.northernwall.hadrian.parameters.ParameterChangeListener;
import com.northernwall.hadrian.parameters.Parameters;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHelper
implements ParameterChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(ConfigHelper.class);
    private final Parameters parameters;
    private final ModuleArtifactHelper moduleArtifactHelper;
    private final ModuleConfigHelper moduleConfigHelper;
    private final AtomicReference<Config> config;

    public ConfigHelper(Parameters parameters, ModuleArtifactHelper moduleArtifactHelper, ModuleConfigHelper moduleConfigHelper) {
        this.parameters = parameters;
        this.moduleArtifactHelper = moduleArtifactHelper;
        this.moduleConfigHelper = moduleConfigHelper;
        this.config = new AtomicReference();
        this.config.set(this.loadConfig());
    }

    public Config getConfig() {
        return this.config.get();
    }

    @Override
    public void onChange(List<String> keys) {
        this.config.set(this.loadConfig());
    }

    private Config loadConfig() {
        Config newConfig = new Config();
        newConfig.mavenGroupId = this.parameters.getString("config.mavenGroupId", "");
        newConfig.versionUrl = this.parameters.getString("config.versionUrl", "{host}.mydomain.com:9090/version");
        newConfig.availabilityUrl = this.parameters.getString("config.availabilityUrl", "{host}.mydomain.com:9090/availability");
        newConfig.deploymentFolder = this.parameters.getString("config.deploymentFolder", "/home/app");
        newConfig.dataFolder = this.parameters.getString("config.dataFolder", "/var/app/data");
        newConfig.logsFolder = this.parameters.getString("config.logsFolder", "/var/app/logs");
        newConfig.gitUiURL = this.parameters.getString("gitUiUrl", "http://127.0.0.1/");
        newConfig.moduleConfigName = this.moduleConfigHelper == null ? "Config Name" : this.moduleConfigHelper.getDisplayName();
        this.loadConfig("config.dataCenters", "dc", newConfig.dataCenters);
        this.loadConfig("config.envs", "Java7, Java8", newConfig.envs);
        this.loadConfig("config.protocols", "HTTP, HTTPS, TCP", newConfig.protocols);
        this.loadConfig("config.domains", "northernwall.com", newConfig.domains);
        this.loadConfig("config.artifactTypes", "jar, war, targz", newConfig.artifactTypes);
        this.loadNetwork(newConfig);
        newConfig.deployableTemplates.add("No template");
        newConfig.libraryTemplates.add("No template");
        newConfig.testTemplates.add("No template");
        this.loadConfig("config.templates.deployable", null, newConfig.deployableTemplates);
        this.loadConfig("config.templates.library", null, newConfig.libraryTemplates);
        this.loadConfig("config.templates.test", null, newConfig.testTemplates);
        newConfig.serviceTypes.add("Service");
        newConfig.serviceTypes.add("Shared Library");
        newConfig.gitModes.add(GitMode.Consolidated);
        newConfig.gitModes.add(GitMode.Flat);
        logger.info("Config loaded");
        return newConfig;
    }

    private void loadConfig(String key, String defaultValue, List<String> target) {
        String[] parts;
        String temp = this.parameters.getString(key, defaultValue);
        if (temp == null) {
            return;
        }
        for (String part : parts = temp.split(",")) {
            if ((part = part.trim()).isEmpty()) continue;
            target.add(part);
        }
    }

    private void loadNetwork(Config newConfig) {
        String temp = this.parameters.getString("config.networks", "[{\"name\":\"Prod\",\"pattern\":\"{dc}-prd-{abbr}-\"},{\"name\":\"CIE\",\"pattern\":\"{dc}-cie-{abbr}-\"},{\"name\":\"Sandbox\",\"pattern\":\"{dc}-tst-{abbr}-\"},{\"name\":\"Reg\",\"pattern\":\"{dc}-tst-{abbr}reg-\",\"allowUrl\":true}]");
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<Network>>(){}.getType();
        newConfig.networks = (List)gson.fromJson(temp, listType);
        for (Network network : newConfig.networks) {
            newConfig.networkNames.add(network.name);
        }
    }
}

