/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.utilityHandlers;

import com.northernwall.hadrian.utilityHandlers.Route;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(RoutingHandler.class);
    private final Map<Route, Handler> routes = new ConcurrentHashMap<Route, Handler>();

    public void addRoute(String target, String method, Handler handler) {
        Route route = new Route(target, method);
        this.routes.put(route, handler);
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Route route = new Route(target, request.getMethod());
        Handler handler = this.routes.get(route);
        if (handler == null) {
            return;
        }
        handler.handle(target, request, httpRequest, response);
    }
}

