/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.utilityHandlers;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.maven.MavenHelper;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailabilityHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(AvailabilityHandler.class);
    private static final String VERSION = "1.3.21";
    private final Handler accessHandler;
    private final DataAccess dataAccess;
    private final MavenHelper mavenHelper;

    public AvailabilityHandler(Handler accessHandler, DataAccess dataAccess, MavenHelper mavenHelper) {
        this.accessHandler = accessHandler;
        this.dataAccess = dataAccess;
        this.mavenHelper = mavenHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (target.equals("/availability")) {
                if (this.dataAccess.getAvailability()) {
                    response.setStatus(200);
                } else {
                    response.setStatus(500);
                }
                request.setHandled(true);
            } else if (target.equals("/version")) {
                response.setStatus(200);
                String version = VERSION;
                response.getOutputStream().write(version.getBytes());
                request.setHandled(true);
            } else if (target.equals("/health")) {
                response.setStatus(200);
                this.showHealth(response);
                request.setHandled(true);
            }
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
        }
    }

    private void showHealth(HttpServletResponse response) throws IOException {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        this.writeln(response, "<html>");
        this.writeln(response, "<body>");
        this.writeln(response, "<table>");
        this.writeln(response, "Version", VERSION);
        this.writeln(response, "JVM Name", runtimeMXBean.getSpecName());
        this.writeln(response, "JVM Version", runtimeMXBean.getSpecVersion());
        this.writeln(response, "JVM Vendor", runtimeMXBean.getSpecVendor());
        this.writeln(response, "JVM Threads", threadMXBean.getThreadCount());
        this.writeln(response, "JVM Peak Threads", threadMXBean.getPeakThreadCount());
        this.writeln(response, "Current Time", new Date());
        this.writeln(response, "Start Time", new Date(runtimeMXBean.getStartTime()));
        this.writeln(response, "Class - Access Handler", this.accessHandler.getClass().getCanonicalName());
        this.writeln(response, "Class - Data Access", this.dataAccess.getClass().getCanonicalName());
        this.writeln(response, "Class - Maven Helper", this.mavenHelper.getClass().getCanonicalName());
        Map<String, String> healthMap = this.dataAccess.getHealth();
        TreeSet<String> keys = new TreeSet<String>(healthMap.keySet());
        for (String key : keys) {
            this.writeln(response, key, healthMap.get(key));
        }
        this.writeln(response, "</table>");
        this.writeln(response, "</body>");
        this.writeln(response, "</html>");
    }

    private void writeln(HttpServletResponse response, String text) throws IOException {
        response.getOutputStream().write(text.getBytes());
    }

    private void writeln(HttpServletResponse response, String label, Date value) throws IOException {
        this.writeln(response, label, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value));
    }

    private void writeln(HttpServletResponse response, String label, int value) throws IOException {
        this.writeln(response, label, Integer.toString(value));
    }

    private void writeln(HttpServletResponse response, String label, String value) throws IOException {
        String text = "<tr><td>" + label + "</td><td>" + value + "</td></tr>";
        response.getOutputStream().write(text.getBytes());
    }
}

