/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service.helper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.service.dao.GetHostDetailsData;
import com.northernwall.hadrian.service.dao.GetPairData;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDetailsHelper {
    private static final Logger logger = LoggerFactory.getLogger(HostDetailsHelper.class);
    private final OkHttpClient client;
    private final String urlTemplate;
    private final JsonParser parser;
    private final List<String> attributes;

    public HostDetailsHelper(OkHttpClient client, Parameters parameters) {
        this.client = client;
        this.urlTemplate = parameters.getString("host.detailsUrl", null);
        this.parser = new JsonParser();
        this.attributes = new LinkedList<String>();
        String temp = parameters.getString("host.detailsAttrs", null);
        if (temp != null) {
            String[] parts;
            for (String part : parts = temp.split(",")) {
                if ((part = part.trim()).isEmpty()) continue;
                this.attributes.add(part);
            }
        }
    }

    public GetHostDetailsData getDetails(Host host) {
        GetHostDetailsData details = new GetHostDetailsData();
        if (this.urlTemplate != null) {
            String url = this.urlTemplate.replace("{host}", host.getHostName());
            Request httpRequest = new Request.Builder().url(url).build();
            try {
                Response resp = this.client.newCall(httpRequest).execute();
                if (resp.isSuccessful()) {
                    InputStreamReader reader = new InputStreamReader(resp.body().byteStream());
                    JsonElement jsonElement = this.parser.parse((Reader)reader);
                    if (jsonElement.isJsonObject()) {
                        JsonObject jsonObject = jsonElement.getAsJsonObject();
                        for (Map.Entry entry : jsonObject.entrySet()) {
                            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                                this.addPair((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString(), details);
                                continue;
                            }
                            if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                            StringBuffer buffer = null;
                            JsonArray jsonArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                            for (int i = 0; i < jsonArray.size(); ++i) {
                                JsonElement arrayElement = jsonArray.get(i);
                                if (!arrayElement.isJsonPrimitive()) continue;
                                if (buffer == null) {
                                    buffer = new StringBuffer(arrayElement.getAsString());
                                    continue;
                                }
                                buffer.append(", ");
                                buffer.append(arrayElement.getAsString());
                            }
                            if (buffer == null) continue;
                            this.addPair((String)entry.getKey(), buffer.toString(), details);
                        }
                    }
                } else {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resp.body().byteStream()));
                    this.addPair("Error", reader.readLine(), details);
                }
            }
            catch (IOException ex) {
                logger.warn("Error while getting secondary host details for {}, error {}", (Object)host.getHostName(), (Object)ex.getMessage());
                this.addPair("Error", "Read failure", details);
            }
        }
        return details;
    }

    private void addPair(String label, String value, GetHostDetailsData details) {
        if (label == null || label.isEmpty() || value == null || value.isEmpty()) {
            return;
        }
        if (this.attributes.isEmpty() || this.attributes.contains(label)) {
            label = label.replace("-", " ").replace("_", " ");
            if (details.left.size() == details.right.size()) {
                details.left.add(new GetPairData(label, value));
            } else {
                details.right.add(new GetPairData(label, value));
            }
        }
    }
}

