/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service.dao;

import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.service.dao.GetCustomFunctionData;
import com.northernwall.hadrian.service.dao.GetDataStoreData;
import com.northernwall.hadrian.service.dao.GetModuleData;
import com.northernwall.hadrian.service.dao.GetPairData;
import com.northernwall.hadrian.service.dao.GetServiceRefData;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GetServiceData {
    public String serviceId;
    public String serviceAbbr;
    public String serviceName;
    public String teamId;
    public String description;
    public String serviceType;
    public String gitMode;
    public String gitPath;
    public Date creationDate;
    public List<GetModuleData> modules;
    public List<GetDataStoreData> dataStores;
    public List<GetCustomFunctionData> customFunctions;
    public List<GetServiceRefData> uses;
    public List<GetServiceRefData> usedBy;
    public List<GetPairData> links;
    public boolean canModify;

    public static GetServiceData create(Service service) {
        GetServiceData temp = new GetServiceData();
        temp.serviceId = service.getServiceId();
        temp.serviceAbbr = service.getServiceAbbr();
        temp.serviceName = service.getServiceName();
        temp.teamId = service.getTeamId();
        temp.description = service.getDescription();
        temp.serviceType = service.getServiceType();
        temp.gitMode = service.getGitMode();
        temp.gitPath = service.getGitPath();
        temp.creationDate = service.getCreationDate();
        temp.modules = new LinkedList<GetModuleData>();
        temp.dataStores = new LinkedList<GetDataStoreData>();
        temp.customFunctions = new LinkedList<GetCustomFunctionData>();
        temp.uses = new LinkedList<GetServiceRefData>();
        temp.usedBy = new LinkedList<GetServiceRefData>();
        temp.links = new LinkedList<GetPairData>();
        if (service.getLinks() != null && !service.getLinks().isEmpty()) {
            for (Map.Entry<String, String> entry : service.getLinks().entrySet()) {
                temp.links.add(new GetPairData(entry.getKey(), entry.getValue()));
            }
        }
        return temp;
    }
}

