/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.Util;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.service.dao.GetUsersData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(UserHandler.class);
    private final AccessHelper accessHelper;
    private final DataAccess dataAccess;
    private final Gson gson;

    public UserHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        this.accessHelper = accessHelper;
        this.dataAccess = dataAccess;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (target.matches("/v1/users")) {
                logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                switch (request.getMethod()) {
                    case "GET": {
                        this.getUsers(response);
                    }
                }
                response.setStatus(200);
                request.setHandled(true);
            }
            if (target.startsWith("/v1/user/")) {
                logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                switch (request.getMethod()) {
                    case "PUT": {
                        this.updateUser(request, target.substring(9));
                    }
                }
                response.setStatus(200);
                request.setHandled(true);
            }
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
        }
    }

    private void getUsers(HttpServletResponse response) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        GetUsersData getUsersData = new GetUsersData();
        List<User> users = this.dataAccess.getUsers();
        Collections.sort(users);
        for (User user : users) {
            getUsersData.users.add(user);
        }
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)getUsersData, GetUsersData.class, jw);
        }
    }

    private void updateUser(Request request, String username) throws IOException {
        this.accessHelper.checkIfUserIsAdmin(request, "update user");
        User temp = Util.fromJson(request, User.class);
        this.dataAccess.updateUser(temp);
    }
}

