/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.Util;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.service.dao.GetTeamData;
import com.northernwall.hadrian.service.dao.PostTeamData;
import com.northernwall.hadrian.service.dao.PutTeamData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(TeamHandler.class);
    private final AccessHelper accessHelper;
    private final DataAccess dataAccess;
    private final Gson gson;

    public TeamHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        this.accessHelper = accessHelper;
        this.dataAccess = dataAccess;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (target.startsWith("/v1/team")) {
                switch (request.getMethod()) {
                    case "GET": {
                        if (!target.matches("/v1/team/\\w+-\\w+-\\w+-\\w+-\\w+")) break;
                        logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                        this.getTeam(request, response, target.substring(9, target.length()));
                        response.setStatus(200);
                        request.setHandled(true);
                        break;
                    }
                    case "POST": {
                        if (!target.equals("/v1/team")) break;
                        this.createTeam(request);
                        response.setStatus(200);
                        request.setHandled(true);
                        break;
                    }
                    case "PUT": {
                        if (target.matches("/v1/team/\\w+-\\w+-\\w+-\\w+-\\w+")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            String teamId = target.substring(9, target.length());
                            this.updateTeam(request, teamId);
                            response.setStatus(200);
                            request.setHandled(true);
                            break;
                        }
                        if (!target.matches("/v1/team/\\w+-\\w+-\\w+-\\w+-\\w+/\\w+")) break;
                        logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                        String temp = target.substring(9, target.length());
                        int i = temp.indexOf("/");
                        this.addUserToTeam(request, temp.substring(0, i), temp.substring(i + 1));
                        response.setStatus(200);
                        request.setHandled(true);
                        break;
                    }
                    case "DELETE": {
                        if (!target.matches("/v1/team/\\w+-\\w+-\\w+-\\w+-\\w+/\\w+")) break;
                        logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                        String temp = target.substring(9, target.length());
                        int i = temp.indexOf("/");
                        this.removeUserFromTeam(request, temp.substring(0, i), temp.substring(i + 1));
                        response.setStatus(200);
                        request.setHandled(true);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
        }
    }

    private void getTeam(Request request, HttpServletResponse response, String teamId) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        Team team = this.dataAccess.getTeam(teamId);
        if (team == null) {
            throw new RuntimeException("Could not find team with id '" + teamId + "'");
        }
        GetTeamData getTeamData = GetTeamData.create(team);
        getTeamData.canModify = this.accessHelper.canUserModify(request, teamId);
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)getTeamData, GetTeamData.class, jw);
        }
    }

    private void createTeam(Request request) throws IOException {
        this.accessHelper.checkIfUserIsAdmin(request, "create team");
        PostTeamData postTeamData = Util.fromJson(request, PostTeamData.class);
        if (postTeamData.user == null) {
            throw new RuntimeException("Failed to create new team, as user is null");
        }
        if (postTeamData.teamName == null) {
            throw new RuntimeException("Failed to create new team, as team name is null");
        }
        postTeamData.teamName = postTeamData.teamName.trim();
        if (postTeamData.teamName.isEmpty()) {
            throw new RuntimeException("Failed to create new team, as team name is empty");
        }
        for (Team temp : this.dataAccess.getTeams()) {
            if (!temp.getTeamName().equals(postTeamData.teamName)) continue;
            throw new RuntimeException("Failed to create new team, as team with name " + postTeamData.teamName + " already exists");
        }
        Team team = new Team(postTeamData.teamName, postTeamData.teamEmail, postTeamData.teamIrc, postTeamData.gitRepo, postTeamData.calendarId);
        if (this.dataAccess.getUser(postTeamData.user.getUsername()) == null) {
            throw new RuntimeException("Failed to create new team, could not find initial user " + postTeamData.user.getUsername());
        }
        team.getUsernames().add(postTeamData.user.getUsername());
        this.dataAccess.saveTeam(team);
    }

    private void updateTeam(Request request, String teamId) throws IOException {
        this.accessHelper.checkIfUserCanModify(request, teamId, "update team");
        Team team = this.dataAccess.getTeam(teamId);
        if (team == null) {
            throw new RuntimeException("Can not find team " + teamId + ", could not update team");
        }
        PutTeamData putTeamData = Util.fromJson(request, PutTeamData.class);
        team.setTeamName(putTeamData.teamName);
        team.setTeamEmail(putTeamData.teamEmail);
        team.setTeamIrc(putTeamData.teamIrc);
        team.setGitRepo(putTeamData.gitRepo);
        team.setCalendarId(putTeamData.calendarId);
        this.dataAccess.saveTeam(team);
    }

    private void addUserToTeam(Request request, String teamId, String username) {
        this.accessHelper.checkIfUserCanModify(request, teamId, "add user to team");
        if (this.dataAccess.getUser(username) == null) {
            throw new RuntimeException("Failed to add user " + username + " to team " + teamId + ", could not find user");
        }
        Team team = this.dataAccess.getTeam(teamId);
        if (team == null) {
            throw new RuntimeException("Failed to add user " + username + " to team " + teamId + ", could not find team");
        }
        team.getUsernames().add(username);
        this.dataAccess.updateTeam(team);
    }

    private void removeUserFromTeam(Request request, String teamId, String username) {
        this.accessHelper.checkIfUserCanModify(request, teamId, "add user to team");
        Team team = this.dataAccess.getTeam(teamId);
        if (team == null) {
            throw new RuntimeException("Failed to add user " + username + " to team " + teamId + ", could not find team");
        }
        if (team.getUsernames().size() < 2) {
            throw new RuntimeException("Can not remove the last user from team " + team.getTeamName());
        }
        team.getUsernames().remove(username);
        this.dataAccess.updateTeam(team);
    }
}

