/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.Util;
import com.northernwall.hadrian.access.AccessException;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.DataStore;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.ServiceRef;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.VipRef;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.maven.MavenHelper;
import com.northernwall.hadrian.service.dao.GetAuditData;
import com.northernwall.hadrian.service.dao.GetCustomFunctionData;
import com.northernwall.hadrian.service.dao.GetDataStoreData;
import com.northernwall.hadrian.service.dao.GetHostData;
import com.northernwall.hadrian.service.dao.GetModuleData;
import com.northernwall.hadrian.service.dao.GetNotUsesData;
import com.northernwall.hadrian.service.dao.GetServiceData;
import com.northernwall.hadrian.service.dao.GetServiceRefData;
import com.northernwall.hadrian.service.dao.GetServicesData;
import com.northernwall.hadrian.service.dao.GetVipData;
import com.northernwall.hadrian.service.dao.GetVipRefData;
import com.northernwall.hadrian.service.dao.PostServiceData;
import com.northernwall.hadrian.service.dao.PostServiceRefData;
import com.northernwall.hadrian.service.dao.PutServiceData;
import com.northernwall.hadrian.service.helper.InfoHelper;
import com.northernwall.hadrian.service.helper.ReadAvailabilityRunnable;
import com.northernwall.hadrian.service.helper.ReadMavenVersionsRunnable;
import com.northernwall.hadrian.service.helper.ReadVersionRunnable;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceHandler.class);
    private final AccessHelper accessHelper;
    private final DataAccess dataAccess;
    private final WorkItemProcessor workItemProcess;
    private final Config config;
    private final MavenHelper mavenHelper;
    private final InfoHelper infoHelper;
    private final Gson gson;
    private final ExecutorService executorService;
    private final DateFormat format;

    public ServiceHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcess, Config config, MavenHelper mavenHelper, InfoHelper infoHelper) {
        this.accessHelper = accessHelper;
        this.dataAccess = dataAccess;
        this.workItemProcess = workItemProcess;
        this.config = config;
        this.mavenHelper = mavenHelper;
        this.infoHelper = infoHelper;
        this.gson = new Gson();
        this.executorService = Executors.newFixedThreadPool(20);
        this.format = new SimpleDateFormat("MM/dd/yyyy");
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (target.startsWith("/v1/service")) {
                switch (request.getMethod()) {
                    case "GET": {
                        if (target.matches("/v1/service")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            this.getServices(response);
                            response.setStatus(200);
                            request.setHandled(true);
                            break;
                        }
                        if (target.matches("/v1/service/\\w+-\\w+-\\w+-\\w+-\\w+/notuses")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            this.getServiceNotUses(response, target.substring(12, target.length() - 8));
                            response.setStatus(200);
                            request.setHandled(true);
                            break;
                        }
                        if (target.matches("/v1/service/\\w+-\\w+-\\w+-\\w+-\\w+/audit")) {
                            String start = request.getParameter("start");
                            String end = request.getParameter("end");
                            logger.info("Handling {} request {} start {} end {}", new Object[]{request.getMethod(), target, start, end});
                            this.getServiceAudit(response, target.substring(12, target.length() - 6), start, end);
                            response.setStatus(200);
                            request.setHandled(true);
                            break;
                        }
                        if (!target.matches("/v1/service/\\w+-\\w+-\\w+-\\w+-\\w+")) break;
                        logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                        this.getService(request, response, target.substring(12, target.length()));
                        response.setStatus(200);
                        request.setHandled(true);
                        break;
                    }
                    case "POST": {
                        if (target.matches("/v1/service/service")) {
                            logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                            this.createService(request);
                            response.setStatus(200);
                            request.setHandled(true);
                            break;
                        }
                        if (!target.matches("/v1/service/\\w+-\\w+-\\w+-\\w+-\\w+/ref")) break;
                        logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                        this.createServiceRef(request, target.substring(12, target.length() - 4));
                        response.setStatus(200);
                        request.setHandled(true);
                        break;
                    }
                    case "PUT": {
                        if (!target.matches("/v1/service/\\w+-\\w+-\\w+-\\w+-\\w+")) break;
                        logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                        this.updateService(request, target.substring(12, target.length()));
                        response.setStatus(200);
                        request.setHandled(true);
                        break;
                    }
                    case "DELETE": {
                        if (!target.matches("/v1/service/\\w+-\\w+-\\w+-\\w+-\\w+/uses/\\w+-\\w+-\\w+-\\w+-\\w+")) break;
                        logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                        this.deleteServiceRef(request, target.substring(12, target.length() - 42), target.substring(54, target.length()));
                        response.setStatus(200);
                        request.setHandled(true);
                    }
                }
            }
        }
        catch (AccessException e) {
            logger.error("Exception {} while handling request for {}", (Object)e.getMessage(), (Object)target);
            response.setStatus(401);
            request.setHandled(true);
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
            request.setHandled(true);
        }
    }

    private void getServices(HttpServletResponse response) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        List<Service> services = this.dataAccess.getServices();
        GetServicesData getServicesData = new GetServicesData();
        for (Service service : services) {
            getServicesData.services.add(GetServiceData.create(service));
        }
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)getServicesData, GetServicesData.class, jw);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getService(Request request, HttpServletResponse response, String id) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        Service service = this.dataAccess.getService(id);
        if (service == null) {
            throw new RuntimeException("Could not find service with id '" + id + "'");
        }
        GetServiceData getServiceData = GetServiceData.create(service);
        getServiceData.canModify = this.accessHelper.canUserModify(request, service.getTeamId());
        LinkedList<Future> futures = new LinkedList<Future>();
        List<Module> modules = this.dataAccess.getModules(id);
        Collections.sort(modules);
        for (Module module : modules) {
            GetModuleData getModuleData = GetModuleData.create(module, this.config);
            futures.add(this.executorService.submit(new ReadMavenVersionsRunnable(getModuleData, this.mavenHelper)));
            getServiceData.modules.add(getModuleData);
        }
        List<Vip> vips = this.dataAccess.getVips(id);
        Collections.sort(vips);
        for (Vip vip : vips) {
            void var11_17;
            Object var11_18 = null;
            for (GetModuleData getModuleData : getServiceData.modules) {
                if (!vip.getModuleId().equals(getModuleData.moduleId)) continue;
                GetModuleData getModuleData2 = getModuleData;
            }
            if (var11_17 == null) continue;
            GetVipData getVipData = GetVipData.create(vip);
            var11_17.addVip(getVipData);
        }
        List<Host> list = this.dataAccess.getHosts(id);
        Collections.sort(list);
        for (Host host : list) {
            void var12_31;
            Object var12_30 = null;
            for (GetModuleData getModuleData : getServiceData.modules) {
                if (!host.getModuleId().equals(getModuleData.moduleId)) continue;
                GetModuleData getModuleData3 = getModuleData;
            }
            if (var12_31 == null) continue;
            GetHostData getHostData = GetHostData.create(host);
            futures.add(this.executorService.submit(new ReadVersionRunnable(getHostData, (GetModuleData)var12_31, this.infoHelper)));
            futures.add(this.executorService.submit(new ReadAvailabilityRunnable(getHostData, (GetModuleData)var12_31, this.infoHelper)));
            for (VipRef vipRef : this.dataAccess.getVipRefsByHost(getHostData.hostId)) {
                GetVipRefData getVipRefData = GetVipRefData.create(vipRef);
                for (GetVipData vip : var12_31.getVips(host.getNetwork())) {
                    if (!vip.vipId.equals(getVipRefData.vipId)) continue;
                    getVipRefData.vipName = vip.vipName;
                }
                getHostData.vipRefs.add(getVipRefData);
            }
            var12_31.addHost(getHostData);
        }
        List<DataStore> list2 = this.dataAccess.getDataStores(id);
        Collections.sort(list2);
        for (DataStore dataStore : list2) {
            GetDataStoreData getDataStoreData = GetDataStoreData.create(dataStore);
            getServiceData.dataStores.add(getDataStoreData);
        }
        for (ServiceRef serviceRef : this.dataAccess.getServiceRefsByClient(id)) {
            GetServiceRefData getServiceRefData = GetServiceRefData.create(serviceRef);
            getServiceRefData.serviceName = this.dataAccess.getService(serviceRef.getServerServiceId()).getServiceName();
            getServiceData.uses.add(getServiceRefData);
        }
        for (ServiceRef serviceRef : this.dataAccess.getServiceRefsByServer(id)) {
            GetServiceRefData getServiceRefData = GetServiceRefData.create(serviceRef);
            getServiceRefData.serviceName = this.dataAccess.getService(serviceRef.getClientServiceId()).getServiceName();
            getServiceData.usedBy.add(getServiceRefData);
        }
        List<CustomFunction> list3 = this.dataAccess.getCustomFunctions(id);
        Collections.sort(list3);
        for (CustomFunction customFunction : list3) {
            GetCustomFunctionData getCustomFunctionData = GetCustomFunctionData.create(customFunction);
            getServiceData.customFunctions.add(getCustomFunctionData);
        }
        this.waitForFutures(futures);
        Throwable throwable = null;
        try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)getServiceData, GetServiceData.class, jsonWriter);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    private void waitForFutures(List<Future> futures) {
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            futures.removeIf(new Predicate<Future>(){

                @Override
                public boolean test(Future t) {
                    return t.isDone();
                }
            });
            if (!futures.isEmpty()) continue;
            return;
        }
    }

    private void getServiceNotUses(HttpServletResponse response, String id) throws IOException {
        logger.info("got here {}", (Object)id);
        List<Service> services = this.dataAccess.getServices();
        List<ServiceRef> refs = this.dataAccess.getServiceRefsByClient(id);
        GetNotUsesData notUses = new GetNotUsesData();
        for (Service service : services) {
            if (service.getServiceId().equals(id)) continue;
            boolean found = false;
            for (ServiceRef ref : refs) {
                if (!service.getServiceId().equals(ref.getServerServiceId())) continue;
                found = true;
            }
            if (found) continue;
            GetServiceRefData ref = new GetServiceRefData();
            ref.clientServiceId = id;
            ref.serverServiceId = service.getServiceId();
            ref.serviceName = service.getServiceName();
            notUses.refs.add(ref);
        }
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)notUses, GetNotUsesData.class, jw);
        }
    }

    private void getServiceAudit(HttpServletResponse response, String id, String start, String end) throws IOException {
        GetAuditData auditData = new GetAuditData();
        Date startDate = null;
        try {
            startDate = this.format.parse(start);
        }
        catch (ParseException ex) {
            Calendar now = Calendar.getInstance();
            now.add(5, -15);
            startDate = now.getTime();
        }
        Date endDate = null;
        try {
            endDate = this.format.parse(end);
        }
        catch (ParseException ex) {
            Calendar now = Calendar.getInstance();
            now.add(5, 1);
            endDate = now.getTime();
        }
        auditData.audits = this.dataAccess.getAudit(id, startDate, endDate);
        Collections.sort(auditData.audits);
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)auditData, GetAuditData.class, jw);
        }
    }

    private void createService(Request request) throws IOException {
        PostServiceData postServiceData = Util.fromJson(request, PostServiceData.class);
        User user = this.accessHelper.checkIfUserCanModify(request, postServiceData.teamId, "create a service");
        postServiceData.serviceAbbr = postServiceData.serviceAbbr.toLowerCase();
        for (Service temp : this.dataAccess.getServices(postServiceData.teamId)) {
            if (!temp.getServiceAbbr().equals(postServiceData.serviceAbbr)) continue;
            logger.warn("A service already exists with that abbreviation, {}", (Object)postServiceData.serviceAbbr);
            return;
        }
        Team team = this.dataAccess.getTeam(postServiceData.teamId);
        if (postServiceData.serviceType.equals("Shared Library")) {
            postServiceData.gitMode = "Flat";
        }
        Service service = new Service(postServiceData.serviceAbbr.toUpperCase(), postServiceData.serviceName, postServiceData.teamId, postServiceData.description, postServiceData.serviceType, postServiceData.gitMode, postServiceData.gitPath);
        this.dataAccess.saveService(service);
        WorkItem workItem = new WorkItem("service", "create", user, team, service, null, null, null, null);
        this.dataAccess.saveWorkItem(workItem);
        this.workItemProcess.sendWorkItem(workItem);
    }

    private void updateService(Request request, String id) throws IOException {
        PutServiceData putServiceData = Util.fromJson(request, PutServiceData.class);
        Service service = this.dataAccess.getService(id);
        if (service == null) {
            throw new RuntimeException("Could not find service");
        }
        this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "modify a service");
        service.setServiceAbbr(putServiceData.serviceAbbr.toUpperCase());
        service.setServiceName(putServiceData.serviceName);
        service.setDescription(putServiceData.description);
        this.dataAccess.updateService(service);
    }

    private void createServiceRef(Request request, String clientId) throws IOException {
        PostServiceRefData postServiceRefData = Util.fromJson(request, PostServiceRefData.class);
        Service clientService = this.dataAccess.getService(clientId);
        if (clientService == null) {
            throw new RuntimeException("Could not find service");
        }
        User user = this.accessHelper.checkIfUserCanModify(request, clientService.getTeamId(), "add a service ref");
        for (Map.Entry<String, String> entry : postServiceRefData.uses.entrySet()) {
            String serverId;
            Service serverService;
            if (!entry.getValue().equalsIgnoreCase("true") || (serverService = this.dataAccess.getService(serverId = entry.getKey())) == null) continue;
            ServiceRef ref = new ServiceRef(clientId, serverId);
            this.dataAccess.saveServiceRef(ref);
            HashMap<String, String> notes = new HashMap<String, String>();
            notes.put("uses", serverService.getServiceAbbr());
            this.createAudit(clientId, user.getUsername(), "create", notes);
            notes = new HashMap();
            notes.put("use_by", clientService.getServiceAbbr());
            this.createAudit(serverId, user.getUsername(), "create", notes);
        }
    }

    private void deleteServiceRef(Request request, String clientId, String serverId) {
        Service clientService = this.dataAccess.getService(clientId);
        if (clientService == null) {
            return;
        }
        Service serverService = this.dataAccess.getService(serverId);
        if (serverService == null) {
            return;
        }
        User user = this.accessHelper.checkIfUserCanModify(request, clientService.getTeamId(), "delete a service ref");
        this.dataAccess.deleteServiceRef(clientId, serverId);
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put("uses", serverService.getServiceAbbr());
        this.createAudit(clientId, user.getUsername(), "delete", notes);
        notes = new HashMap();
        notes.put("use_by", clientService.getServiceAbbr());
        this.createAudit(serverId, user.getUsername(), "delete", notes);
    }

    private void createAudit(String serviceId, String requestor, String operation, Map<String, String> notes) {
        Audit audit = new Audit();
        audit.serviceId = serviceId;
        audit.timePerformed = new Date();
        audit.timeRequested = new Date();
        audit.requestor = requestor;
        audit.type = "serviceRef";
        audit.operation = operation;
        audit.notes = this.gson.toJson(notes);
        this.dataAccess.saveAudit(audit, " ");
    }
}

