/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.domain.Config;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConfigHandler.class);
    private final Config config;
    private final Gson gson;

    public ConfigHandler(Config config) {
        this.config = config;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (target.matches("/v1/config")) {
                logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                switch (request.getMethod()) {
                    case "GET": {
                        this.getConfig(response);
                    }
                }
                response.setStatus(200);
                request.setHandled(true);
            }
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
        }
    }

    private void getConfig(HttpServletResponse response) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)this.config, Config.class, jw);
        }
    }
}

