/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.service;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.CalendarEntry;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.service.dao.GetCalendarData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(CalendarHandler.class);
    private final DataAccess dataAccess;
    private final CalendarHelper calendarHelper;
    private final Gson gson;

    public CalendarHandler(DataAccess dataAccess, CalendarHelper calendarHelper) {
        this.dataAccess = dataAccess;
        this.calendarHelper = calendarHelper;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (request.getMethod().equals("GET") && target.equals("/v1/calendar")) {
                logger.info("Handling {} request {}", (Object)request.getMethod(), (Object)target);
                this.getCalendar(request.getParameter("serviceId"), response);
                response.setStatus(200);
                request.setHandled(true);
            }
        }
        catch (Exception e) {
            logger.error("Exception {} while handling request for {}", new Object[]{e.getMessage(), target, e});
            response.setStatus(400);
        }
    }

    private void getCalendar(String serviceId, HttpServletResponse response) throws IOException {
        Team team;
        Service service;
        GetCalendarData getCalendarData = new GetCalendarData();
        if (serviceId != null && !serviceId.isEmpty() && (service = this.dataAccess.getService(serviceId)) != null && (team = this.dataAccess.getTeam(service.getTeamId())) != null) {
            getCalendarData.entries = this.calendarHelper.getCalendarEntries(team);
            if (getCalendarData.entries == null) {
                getCalendarData.entries = new LinkedList<CalendarEntry>();
            }
            if (getCalendarData.entries.isEmpty()) {
                CalendarEntry entry = new CalendarEntry();
                entry.calendarName = "-";
                entry.starts = "-";
                entry.ends = "-";
                entry.description = "-";
                getCalendarData.entries.add(entry);
            }
        }
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)getCalendarData, GetCalendarData.class, jw);
        }
    }
}

