/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.db.cassandra;

import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.DataStore;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.ServiceRef;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.VipRef;
import com.northernwall.hadrian.domain.WorkItem;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDataAccess
implements DataAccess {
    private static final Logger logger = LoggerFactory.getLogger(CassandraDataAccess.class);
    private static final String CQL_SELECT_PRE = "SELECT * FROM ";
    private static final String CQL_SELECT_POST = ";";
    private final Session session;
    private final PreparedStatement auditSelect;
    private final PreparedStatement auditInsert;
    private final PreparedStatement customFunctionSelect;
    private final PreparedStatement customFunctionSelect2;
    private final PreparedStatement customFunctionInsert;
    private final PreparedStatement customFunctionUpdate;
    private final PreparedStatement customFunctionDelete;
    private final PreparedStatement dataStoreSelect;
    private final PreparedStatement dataStoreSelect2;
    private final PreparedStatement dataStoreInsert;
    private final PreparedStatement dataStoreUpdate;
    private final PreparedStatement dataStoreDelete;
    private final PreparedStatement hostSelect;
    private final PreparedStatement hostSelect2;
    private final PreparedStatement hostInsert;
    private final PreparedStatement hostUpdate;
    private final PreparedStatement hostDelete;
    private final PreparedStatement moduleSelect;
    private final PreparedStatement moduleSelect2;
    private final PreparedStatement moduleInsert;
    private final PreparedStatement moduleUpdate;
    private final PreparedStatement moduleDelete;
    private final PreparedStatement serviceSelect;
    private final PreparedStatement serviceInsert;
    private final PreparedStatement serviceUpdate;
    private final PreparedStatement serviceRefSelectClient;
    private final PreparedStatement serviceRefSelectServer;
    private final PreparedStatement serviceRefInsertClient;
    private final PreparedStatement serviceRefInsertServer;
    private final PreparedStatement serviceRefDeleteClient;
    private final PreparedStatement serviceRefDeleteServer;
    private final PreparedStatement teamSelect;
    private final PreparedStatement teamInsert;
    private final PreparedStatement teamUpdate;
    private final PreparedStatement userSelect;
    private final PreparedStatement userInsert;
    private final PreparedStatement userUpdate;
    private final PreparedStatement userDelete;
    private final PreparedStatement vipSelect;
    private final PreparedStatement vipSelect2;
    private final PreparedStatement vipInsert;
    private final PreparedStatement vipUpdate;
    private final PreparedStatement vipDelete;
    private final PreparedStatement vipRefSelectHost1;
    private final PreparedStatement vipRefSelectHost2;
    private final PreparedStatement vipRefSelectVip;
    private final PreparedStatement vipRefInsertHost;
    private final PreparedStatement vipRefInsertVip;
    private final PreparedStatement vipRefUpdateHost;
    private final PreparedStatement vipRefDeleteHost;
    private final PreparedStatement vipRefDeleteVip1;
    private final PreparedStatement vipRefDeleteVip2;
    private final PreparedStatement workItemSelect;
    private final PreparedStatement workItemInsert;
    private final PreparedStatement workItemDelete;
    private final Gson gson;

    public CassandraDataAccess(Cluster cluster, String keyspace, int auditTimeToLive, MetricRegistry metricRegistry) {
        this.session = cluster.connect(keyspace);
        this.customFunctionSelect = this.session.prepare("SELECT * FROM customFunction WHERE serviceId = ?;");
        this.customFunctionSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.customFunctionSelect2 = this.session.prepare("SELECT * FROM customFunction WHERE serviceId = ? AND id = ?;");
        this.customFunctionSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.customFunctionInsert = this.session.prepare("INSERT INTO customFunction (serviceId, id, data) VALUES (?, ?, ?);");
        this.customFunctionInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.customFunctionUpdate = this.session.prepare("UPDATE customFunction SET data = ? WHERE serviceId = ? AND id = ?;");
        this.customFunctionUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.customFunctionDelete = this.session.prepare("DELETE FROM customFunction WHERE serviceId = ? AND id = ?;");
        this.customFunctionDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.dataStoreSelect = this.session.prepare("SELECT * FROM dataStore WHERE serviceId = ?;");
        this.dataStoreSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.dataStoreSelect2 = this.session.prepare("SELECT * FROM dataStore WHERE serviceId = ? AND id = ?;");
        this.dataStoreSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.dataStoreInsert = this.session.prepare("INSERT INTO dataStore (serviceId, id, data) VALUES (?, ?, ?);");
        this.dataStoreInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.dataStoreUpdate = this.session.prepare("UPDATE dataStore SET data = ? WHERE serviceId = ? AND id = ?;");
        this.dataStoreUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.dataStoreDelete = this.session.prepare("DELETE FROM dataStore WHERE serviceId = ? AND id = ?;");
        this.dataStoreDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.hostSelect = this.session.prepare("SELECT * FROM host WHERE serviceId = ?;");
        this.hostSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.hostSelect2 = this.session.prepare("SELECT * FROM host WHERE serviceId = ? AND id = ?;");
        this.hostSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.hostInsert = this.session.prepare("INSERT INTO host (serviceId, id, data) VALUES (?, ?, ?);");
        this.hostInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.hostUpdate = this.session.prepare("UPDATE host SET data = ? WHERE serviceId = ? AND id = ?;");
        this.hostUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.hostDelete = this.session.prepare("DELETE FROM host WHERE serviceId = ? AND id = ?;");
        this.hostDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleSelect = this.session.prepare("SELECT * FROM module WHERE serviceId = ?;");
        this.moduleSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleSelect2 = this.session.prepare("SELECT * FROM module WHERE serviceId = ? AND id = ?;");
        this.moduleSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleInsert = this.session.prepare("INSERT INTO module (serviceId, id, data) VALUES (?, ?, ?);");
        this.moduleInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleUpdate = this.session.prepare("UPDATE module SET data = ? WHERE serviceId = ? AND id = ?;");
        this.moduleUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleDelete = this.session.prepare("DELETE FROM module WHERE serviceId = ? AND id = ?;");
        this.moduleDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceSelect = this.session.prepare("SELECT * FROM service WHERE id = ?;");
        this.serviceSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceInsert = this.session.prepare("INSERT INTO service (id, data) VALUES (?, ?);");
        this.serviceInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceUpdate = this.session.prepare("UPDATE service SET data = ? WHERE id = ?;");
        this.serviceUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceRefSelectClient = this.session.prepare("SELECT * FROM serviceRefClient WHERE clientServiceId = ?;");
        this.serviceRefSelectClient.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceRefSelectServer = this.session.prepare("SELECT * FROM serviceRefServer WHERE serverServiceId = ?;");
        this.serviceRefSelectServer.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceRefInsertClient = this.session.prepare("INSERT INTO serviceRefClient (clientServiceId, serverServiceId) VALUES (?, ?);");
        this.serviceRefInsertClient.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceRefInsertServer = this.session.prepare("INSERT INTO serviceRefServer (serverServiceId, clientServiceId) VALUES (?, ?);");
        this.serviceRefInsertServer.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceRefDeleteClient = this.session.prepare("DELETE FROM serviceRefClient WHERE clientServiceId = ? AND serverServiceId = ?;");
        this.serviceRefDeleteClient.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceRefDeleteServer = this.session.prepare("DELETE FROM serviceRefServer WHERE serverServiceId = ? AND clientServiceId = ?;");
        this.serviceRefDeleteServer.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.teamSelect = this.session.prepare("SELECT * FROM team WHERE id = ?;");
        this.teamSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.teamInsert = this.session.prepare("INSERT INTO team (id, data) VALUES (?, ?);");
        this.teamInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.teamUpdate = this.session.prepare("UPDATE team SET data = ? WHERE id = ?;");
        this.teamUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.userSelect = this.session.prepare("SELECT * FROM user WHERE id = ?;");
        this.userSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.userInsert = this.session.prepare("INSERT INTO user (id, data) VALUES (?, ?);");
        this.userInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.userUpdate = this.session.prepare("UPDATE user SET data = ? WHERE id = ?;");
        this.userUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.userDelete = this.session.prepare("DELETE FROM user WHERE id = ?;");
        this.userDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipSelect = this.session.prepare("SELECT * FROM vip WHERE serviceId = ?;");
        this.vipSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipSelect2 = this.session.prepare("SELECT * FROM vip WHERE serviceId = ? AND id = ?;");
        this.vipSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipInsert = this.session.prepare("INSERT INTO vip (serviceId, id, data) VALUES (?, ?, ?);");
        this.vipInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipUpdate = this.session.prepare("UPDATE vip SET data = ? WHERE serviceId = ? AND id = ?;");
        this.vipUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipDelete = this.session.prepare("DELETE FROM vip WHERE serviceId = ? AND id = ?;");
        this.vipDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipRefSelectHost1 = this.session.prepare("SELECT * FROM vipRefHost WHERE hostId = ?;");
        this.vipRefSelectHost1.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipRefSelectHost2 = this.session.prepare("SELECT * FROM vipRefHost WHERE hostId = ? AND vipId = ?;");
        this.vipRefSelectHost2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipRefSelectVip = this.session.prepare("SELECT * FROM vipRefVip WHERE vipId = ?;");
        this.vipRefSelectVip.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipRefInsertHost = this.session.prepare("INSERT INTO vipRefHost (hostId, vipId, data) VALUES (?, ?, ?);");
        this.vipRefInsertHost.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipRefInsertVip = this.session.prepare("INSERT INTO vipRefVip (vipId, hostId) VALUES (?, ?);");
        this.vipRefInsertVip.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipRefUpdateHost = this.session.prepare("UPDATE vipRefHost SET data = ? WHERE hostId = ? AND vipId = ?;");
        this.vipRefUpdateHost.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipRefDeleteHost = this.session.prepare("DELETE FROM vipRefHost WHERE hostId = ? AND vipId = ?;");
        this.vipRefDeleteHost.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipRefDeleteVip1 = this.session.prepare("DELETE FROM vipRefVip WHERE vipId = ?;");
        this.vipRefDeleteVip1.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipRefDeleteVip2 = this.session.prepare("DELETE FROM vipRefVip WHERE vipId = ? AND hostId = ?;");
        this.vipRefDeleteVip2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.workItemSelect = this.session.prepare("SELECT * FROM workItem WHERE id = ?;");
        this.workItemSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.workItemInsert = this.session.prepare("INSERT INTO workItem (id, data) VALUES (?, ?);");
        this.workItemInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.workItemDelete = this.session.prepare("DELETE FROM workItem WHERE id = ?;");
        this.workItemDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        logger.info("Audit TTL {}", (Object)auditTimeToLive);
        this.auditSelect = this.session.prepare("SELECT data FROM audit WHERE serviceId = ? AND time >= minTimeuuid(?) AND time < minTimeuuid(?)");
        this.auditInsert = this.session.prepare("INSERT INTO audit (serviceId, time, data, output) VALUES (?, now(), ?, ?) USING TTL " + auditTimeToLive + CQL_SELECT_POST);
        this.auditInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        logger.info("Prapared statements created");
        this.gson = new Gson();
    }

    @Override
    public boolean getAvailability() {
        return true;
    }

    @Override
    public Map<String, String> getHealth() {
        HashMap<String, String> health = new HashMap<String, String>();
        Metadata metadata = this.session.getCluster().getMetadata();
        health.put("Cassandra - Cluster Name", metadata.getClusterName());
        health.put("Cassandra - Session Keyspace", this.session.getLoggedKeyspace());
        int i = 1;
        for (com.datastax.driver.core.Host host : metadata.getAllHosts()) {
            health.put("Cassandra - Host" + i + " Data Center:", host.getDatacenter());
            health.put("Cassandra - Host" + i + " Address:", host.getAddress().getHostAddress());
            health.put("Cassandra - Host" + i + " Rack:", host.getRack());
            health.put("Cassandra - Host" + i + " State:", host.getState());
            health.put("Cassandra - Host" + i + " Version:", host.getCassandraVersion().toString());
            ++i;
        }
        return health;
    }

    @Override
    public List<Team> getTeams() {
        return this.getData("team", Team.class);
    }

    @Override
    public Team getTeam(String teamId) {
        return this.getData(teamId, this.teamSelect, Team.class);
    }

    @Override
    public void saveTeam(Team team) {
        this.saveData(team.getTeamId(), this.gson.toJson((Object)team), this.teamInsert);
    }

    @Override
    public void updateTeam(Team team) {
        this.updateData(team.getTeamId(), this.gson.toJson((Object)team), this.teamUpdate);
    }

    @Override
    public List<Service> getServices() {
        return this.getData("service", Service.class);
    }

    @Override
    public List<Service> getServices(final String teamId) {
        List<Service> services = this.getData("service", Service.class);
        services.removeIf(new Predicate<Service>(){

            @Override
            public boolean test(Service service) {
                return !service.getTeamId().equals(teamId);
            }
        });
        return services;
    }

    @Override
    public Service getService(String serviceId) {
        return this.getData(serviceId, this.serviceSelect, Service.class);
    }

    @Override
    public void saveService(Service service) {
        this.saveData(service.getServiceId(), this.gson.toJson((Object)service), this.serviceInsert);
    }

    @Override
    public void updateService(Service service) {
        this.updateData(service.getServiceId(), this.gson.toJson((Object)service), this.serviceUpdate);
    }

    @Override
    public List<Host> getHosts(String serviceId) {
        return this.getServiceData(serviceId, this.hostSelect, Host.class);
    }

    @Override
    public Host getHost(String serviceId, String hostId) {
        return this.getServiceData(serviceId, hostId, this.hostSelect2, Host.class);
    }

    @Override
    public void saveHost(Host host) {
        this.saveServiceData(host.getServiceId(), host.getHostId(), this.gson.toJson((Object)host), this.hostInsert);
    }

    @Override
    public void updateHost(Host host) {
        this.updateServiceData(host.getServiceId(), host.getHostId(), this.gson.toJson((Object)host), this.hostUpdate);
    }

    @Override
    public void deleteHost(String serviceId, String hostId) {
        this.deleteServiceData(serviceId, hostId, this.hostDelete);
    }

    @Override
    public List<Module> getModules(String serviceId) {
        return this.getServiceData(serviceId, this.moduleSelect, Module.class);
    }

    @Override
    public Module getModule(String serviceId, String moduleId) {
        return this.getServiceData(serviceId, moduleId, this.moduleSelect2, Module.class);
    }

    @Override
    public void saveModule(Module module) {
        this.saveServiceData(module.getServiceId(), module.getModuleId(), this.gson.toJson((Object)module), this.moduleInsert);
    }

    @Override
    public void updateModule(Module module) {
        this.updateServiceData(module.getServiceId(), module.getModuleId(), this.gson.toJson((Object)module), this.moduleUpdate);
    }

    @Override
    public void deleteModule(String serviceId, String moduleId) {
        this.deleteServiceData(serviceId, moduleId, this.moduleDelete);
    }

    @Override
    public List<Vip> getVips(String serviceId) {
        return this.getServiceData(serviceId, this.vipSelect, Vip.class);
    }

    @Override
    public Vip getVip(String serviceId, String vipId) {
        return this.getServiceData(serviceId, vipId, this.vipSelect2, Vip.class);
    }

    @Override
    public void saveVip(Vip vip) {
        this.saveServiceData(vip.getServiceId(), vip.getVipId(), this.gson.toJson((Object)vip), this.vipInsert);
    }

    @Override
    public void updateVip(Vip vip) {
        this.updateServiceData(vip.getServiceId(), vip.getVipId(), this.gson.toJson((Object)vip), this.vipUpdate);
    }

    @Override
    public void deleteVip(String serviceId, String vipId) {
        this.deleteServiceData(serviceId, vipId, this.vipDelete);
    }

    @Override
    public List<ServiceRef> getServiceRefs() {
        ResultSet results = this.session.execute("SELECT * FROM serviceRefClient;");
        LinkedList<ServiceRef> serviceRefs = new LinkedList<ServiceRef>();
        for (Row row : results) {
            serviceRefs.add(new ServiceRef(row.getString("clientServiceId"), row.getString("serverServiceId")));
        }
        return serviceRefs;
    }

    @Override
    public List<ServiceRef> getServiceRefsByClient(String clientServiceId) {
        BoundStatement boundStatement = new BoundStatement(this.serviceRefSelectClient);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{clientServiceId}));
        LinkedList<ServiceRef> serviceRefs = new LinkedList<ServiceRef>();
        for (Row row : results) {
            serviceRefs.add(new ServiceRef(row.getString("clientServiceId"), row.getString("serverServiceId")));
        }
        return serviceRefs;
    }

    @Override
    public List<ServiceRef> getServiceRefsByServer(String serverServiceId) {
        BoundStatement boundStatement = new BoundStatement(this.serviceRefSelectServer);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serverServiceId}));
        LinkedList<ServiceRef> serviceRefs = new LinkedList<ServiceRef>();
        for (Row row : results) {
            serviceRefs.add(new ServiceRef(row.getString("clientServiceId"), row.getString("serverServiceId")));
        }
        return serviceRefs;
    }

    @Override
    public void saveServiceRef(ServiceRef serviceRef) {
        BoundStatement boundStatement = new BoundStatement(this.serviceRefInsertClient);
        this.session.execute((Statement)boundStatement.bind(new Object[]{serviceRef.getClientServiceId(), serviceRef.getServerServiceId()}));
        boundStatement = new BoundStatement(this.serviceRefInsertServer);
        this.session.execute((Statement)boundStatement.bind(new Object[]{serviceRef.getServerServiceId(), serviceRef.getClientServiceId()}));
    }

    @Override
    public void deleteServiceRef(String clientId, String serviceId) {
        BoundStatement boundStatement = new BoundStatement(this.serviceRefDeleteClient);
        this.session.execute((Statement)boundStatement.bind(new Object[]{clientId, serviceId}));
        boundStatement = new BoundStatement(this.serviceRefDeleteServer);
        this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, clientId}));
    }

    @Override
    public List<VipRef> getVipRefsByHost(String hostId) {
        BoundStatement boundStatement = new BoundStatement(this.vipRefSelectHost1);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{hostId}));
        LinkedList<VipRef> vipRefs = new LinkedList<VipRef>();
        for (Row row : results) {
            String data = row.getString("data");
            vipRefs.add((VipRef)this.gson.fromJson(data, VipRef.class));
        }
        return vipRefs;
    }

    @Override
    public VipRef getVipRef(String hostId, String vipId) {
        BoundStatement boundStatement = new BoundStatement(this.vipRefSelectHost2);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{hostId, vipId}));
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String data = row.getString("data");
            return (VipRef)this.gson.fromJson(data, VipRef.class);
        }
        return null;
    }

    @Override
    public void saveVipRef(VipRef vipRef) {
        BoundStatement boundStatement = new BoundStatement(this.vipRefInsertHost);
        this.session.execute((Statement)boundStatement.bind(new Object[]{vipRef.getHostId(), vipRef.getVipId(), this.gson.toJson((Object)vipRef)}));
        boundStatement = new BoundStatement(this.vipRefInsertVip);
        this.session.execute((Statement)boundStatement.bind(new Object[]{vipRef.getVipId(), vipRef.getHostId()}));
    }

    @Override
    public void updateVipRef(VipRef vipRef) {
        BoundStatement boundStatement = new BoundStatement(this.vipRefUpdateHost);
        this.session.execute((Statement)boundStatement.bind(new Object[]{this.gson.toJson((Object)vipRef), vipRef.getHostId(), vipRef.getVipId()}));
    }

    @Override
    public void deleteVipRef(String hostId, String vipId) {
        BoundStatement boundStatement = new BoundStatement(this.vipRefDeleteHost);
        this.session.execute((Statement)boundStatement.bind(new Object[]{hostId, vipId}));
        boundStatement = new BoundStatement(this.vipRefDeleteVip2);
        this.session.execute((Statement)boundStatement.bind(new Object[]{vipId, hostId}));
    }

    @Override
    public void deleteVipRefs(String vipId) {
        BoundStatement boundStatement = new BoundStatement(this.vipRefSelectVip);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{vipId}));
        LinkedList<String> hostIds = new LinkedList<String>();
        for (Row row : results) {
            hostIds.add(row.getString("hostId"));
        }
        for (String hostId : hostIds) {
            boundStatement = new BoundStatement(this.vipRefDeleteHost);
            this.session.execute((Statement)boundStatement.bind(new Object[]{hostId, vipId}));
        }
        boundStatement = new BoundStatement(this.vipRefDeleteVip1);
        this.session.execute((Statement)boundStatement.bind(new Object[]{vipId}));
    }

    @Override
    public List<CustomFunction> getCustomFunctions(String serviceId) {
        return this.getServiceData(serviceId, this.customFunctionSelect, CustomFunction.class);
    }

    @Override
    public CustomFunction getCustomFunction(String serviceId, String customFunctionId) {
        return this.getServiceData(serviceId, customFunctionId, this.customFunctionSelect2, CustomFunction.class);
    }

    @Override
    public void saveCustomFunction(CustomFunction customFunction) {
        this.saveServiceData(customFunction.getServiceId(), customFunction.getCustomFunctionId(), this.gson.toJson((Object)customFunction), this.customFunctionInsert);
    }

    @Override
    public void updateCustomFunction(CustomFunction customFunction) {
        this.updateServiceData(customFunction.getServiceId(), customFunction.getCustomFunctionId(), this.gson.toJson((Object)customFunction), this.customFunctionUpdate);
    }

    @Override
    public void deleteCustomFunction(String serviceId, String customFunctionId) {
        this.deleteServiceData(serviceId, customFunctionId, this.customFunctionDelete);
    }

    @Override
    public List<DataStore> getDataStores(String serviceId) {
        return this.getServiceData(serviceId, this.dataStoreSelect, DataStore.class);
    }

    @Override
    public DataStore getDataStore(String serviceId, String dataStoreId) {
        return this.getServiceData(serviceId, dataStoreId, this.dataStoreSelect2, DataStore.class);
    }

    @Override
    public void saveDataStore(DataStore dataStore) {
        this.saveServiceData(dataStore.getServiceId(), dataStore.getDataStoreId(), this.gson.toJson((Object)dataStore), this.dataStoreInsert);
    }

    @Override
    public void updateDataStore(DataStore dataStore) {
        this.updateServiceData(dataStore.getServiceId(), dataStore.getDataStoreId(), this.gson.toJson((Object)dataStore), this.dataStoreUpdate);
    }

    @Override
    public void deleteDataStore(String serviceId, String dataStoreId) {
        this.deleteServiceData(serviceId, dataStoreId, this.dataStoreDelete);
    }

    @Override
    public List<User> getUsers() {
        return this.getData("user", User.class);
    }

    @Override
    public User getUser(String userName) {
        return this.getData(userName, this.userSelect, User.class);
    }

    @Override
    public void saveUser(User user) {
        this.saveData(user.getUsername(), this.gson.toJson((Object)user), this.userInsert);
    }

    @Override
    public void updateUser(User user) {
        this.updateData(user.getUsername(), this.gson.toJson((Object)user), this.userUpdate);
    }

    @Override
    public void deleteUser(String userName) {
        this.deleteData(userName, this.userDelete);
    }

    @Override
    public List<WorkItem> getWorkItems() {
        return this.getData("workItem", WorkItem.class);
    }

    @Override
    public WorkItem getWorkItem(String id) {
        return this.getData(id, this.workItemSelect, WorkItem.class);
    }

    @Override
    public void saveWorkItem(WorkItem workItem) {
        this.saveData(workItem.getId(), this.gson.toJson((Object)workItem), this.workItemInsert);
    }

    @Override
    public void deleteWorkItem(String id) {
        this.deleteData(id, this.workItemDelete);
    }

    @Override
    public void saveAudit(Audit audit, String output) {
        BoundStatement boundStatement = new BoundStatement(this.auditInsert);
        this.session.execute((Statement)boundStatement.bind(new Object[]{audit.serviceId, this.gson.toJson((Object)audit), output}));
    }

    @Override
    public List<Audit> getAudit(String serviceId, Date start, Date end) {
        BoundStatement boundStatement = new BoundStatement(this.auditSelect);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, start, end}));
        LinkedList<Audit> audits = new LinkedList<Audit>();
        for (Row row : results) {
            String data = row.getString("data");
            audits.add((Audit)this.gson.fromJson(data, Audit.class));
        }
        logger.info("Got {} audit record for {} between {} and {}", new Object[]{audits.size(), serviceId, start, end});
        return audits;
    }

    private <T> List<T> getData(String tableName, Class<T> classOfT) {
        ResultSet results = this.session.execute(CQL_SELECT_PRE + tableName + CQL_SELECT_POST);
        LinkedList<Object> listOfData = new LinkedList<Object>();
        for (Row row : results) {
            String data = row.getString("data");
            listOfData.add(this.gson.fromJson(data, classOfT));
        }
        return listOfData;
    }

    private <T> T getData(String id, PreparedStatement statement, Class<T> classOfT) {
        BoundStatement boundStatement = new BoundStatement(statement);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{id}));
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String data = row.getString("data");
            return (T)this.gson.fromJson(data, classOfT);
        }
        return null;
    }

    private void saveData(String id, String data, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{id, data}));
    }

    private void updateData(String id, String data, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{data, id}));
    }

    private void deleteData(String id, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{id}));
    }

    private <T> List<T> getServiceData(String serviceId, PreparedStatement statement, Class<T> classOfT) {
        BoundStatement boundStatement = new BoundStatement(statement);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId}));
        LinkedList<Object> listOfData = new LinkedList<Object>();
        for (Row row : results) {
            String data = row.getString("data");
            listOfData.add(this.gson.fromJson(data, classOfT));
        }
        return listOfData;
    }

    private <T> T getServiceData(String serviceId, String id, PreparedStatement statement, Class<T> classOfT) {
        BoundStatement boundStatement = new BoundStatement(statement);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, id}));
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String data = row.getString("data");
            return (T)this.gson.fromJson(data, classOfT);
        }
        return null;
    }

    private void saveServiceData(String serviceId, String id, String data, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, id, data}));
    }

    private void updateServiceData(String serviceId, String id, String data, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{data, serviceId, id}));
    }

    private void deleteServiceData(String serviceId, String id, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, id}));
    }

    public void close() {
        this.session.close();
    }
}

