/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.calendar;

import com.northernwall.hadrian.domain.CalendarEntry;
import com.northernwall.hadrian.domain.Team;
import java.util.Date;
import java.util.List;

public abstract class CalendarHelper {
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long MINUS_ONE_MINUTE = -60000L;
    public static final long MINUS_ONE_HOUR = -3600000L;
    public static final long MINUS_ONE_DAY = -86400000L;

    public abstract List<CalendarEntry> getCalendarEntries(Team var1);

    public static String buildStartsEndsText(Date date) {
        return CalendarHelper.buildStartsEndsText(date.getTime());
    }

    public static String buildStartsEndsText(long date) {
        long dif = date - System.currentTimeMillis();
        if (dif < -86400000L) {
            if ((dif /= -86400000L) == -1L) {
                return "1 day ago";
            }
            return dif + " days ago";
        }
        if (dif < -3600000L) {
            if ((dif /= -3600000L) == -1L) {
                return "1 hour ago";
            }
            return dif + " hours ago";
        }
        if (dif <= 0L) {
            if ((dif /= -60000L) == -1L) {
                return "1 minute ago";
            }
            return dif + " minutes ago";
        }
        if (dif > 86400000L) {
            if ((dif /= 86400000L) == 1L) {
                return "in 1 day";
            }
            return "in " + dif + " days";
        }
        if (dif > 3600000L) {
            if ((dif /= 3600000L) == 1L) {
                return "in 1 hour";
            }
            return "in " + dif + " hours";
        }
        if ((dif /= 60000L) == 1L) {
            return "in 1 minute";
        }
        return "in " + dif + " minutes";
    }
}

