/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian;

import com.codahale.metrics.MetricRegistry;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.graph.GraphHandler;
import com.northernwall.hadrian.maven.MavenHelper;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.service.AuditHandler;
import com.northernwall.hadrian.service.CalendarHandler;
import com.northernwall.hadrian.service.ConfigHandler;
import com.northernwall.hadrian.service.CustomFuntionHandler;
import com.northernwall.hadrian.service.DataStoreHandler;
import com.northernwall.hadrian.service.HostHandler;
import com.northernwall.hadrian.service.ModuleHandler;
import com.northernwall.hadrian.service.ServiceHandler;
import com.northernwall.hadrian.service.TeamHandler;
import com.northernwall.hadrian.service.UserHandler;
import com.northernwall.hadrian.service.VipHandler;
import com.northernwall.hadrian.service.WorkItemHandler;
import com.northernwall.hadrian.service.helper.HostDetailsHelper;
import com.northernwall.hadrian.service.helper.InfoHelper;
import com.northernwall.hadrian.tree.TreeHandler;
import com.northernwall.hadrian.utilityHandlers.AvailabilityHandler;
import com.northernwall.hadrian.utilityHandlers.ContentHandler;
import com.northernwall.hadrian.utilityHandlers.MetricHandler;
import com.northernwall.hadrian.utilityHandlers.RedirectHandler;
import com.northernwall.hadrian.workItem.WorkItemCallbackHandler;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.squareup.okhttp.OkHttpClient;
import java.net.BindException;
import java.util.List;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadrian {
    private static final Logger logger = LoggerFactory.getLogger(Hadrian.class);
    private final Parameters parameters;
    private Config config;
    private final DataAccess dataAccess;
    private final MetricRegistry metricRegistry;
    private final OkHttpClient client;
    private final MavenHelper mavenHelper;
    private final AccessHelper accessHelper;
    private final Handler accessHandler;
    private final CalendarHelper calendarHelper;
    private final WorkItemProcessor workItemProcess;
    private final InfoHelper infoHelper;
    private final HostDetailsHelper hostDetailsHelper;
    private int port;
    private Server server;

    Hadrian(Parameters parameters, OkHttpClient client, DataAccess dataAccess, MavenHelper mavenHelper, AccessHelper accessHelper, Handler accessHandler, CalendarHelper calendarHelper, WorkItemProcessor workItemProcess, MetricRegistry metricRegistry) {
        this.parameters = parameters;
        this.client = client;
        this.dataAccess = dataAccess;
        this.mavenHelper = mavenHelper;
        this.accessHelper = accessHelper;
        this.accessHandler = accessHandler;
        this.calendarHelper = calendarHelper;
        this.workItemProcess = workItemProcess;
        this.metricRegistry = metricRegistry;
        this.loadConfig();
        this.infoHelper = new InfoHelper(client);
        this.hostDetailsHelper = new HostDetailsHelper(client, parameters);
        this.setupJetty();
    }

    private void loadConfig(String key, String defaultValue, List<String> target) {
        String[] parts;
        if (key.equals("config.templates")) {
            target.add("No template");
        }
        String temp = this.parameters.getString(key, defaultValue);
        for (String part : parts = temp.split(",")) {
            if ((part = part.trim()).isEmpty()) continue;
            target.add(part);
        }
    }

    private void loadConfig() {
        this.config = new Config();
        this.config.versionUrl = this.parameters.getString("config.versionUrl", "{host}.mydomain.com:9090/version");
        this.config.availabilityUrl = this.parameters.getString("config.availabilityUrl", "{host}.mydomain.com:9090/availability");
        this.config.deploymentFolder = this.parameters.getString("config.deploymentFolder", "/home/app");
        this.config.startCmd = this.parameters.getString("config.startCmd", "screen -d -m java -jar serviceAbbr.jar");
        this.config.stopCmd = this.parameters.getString("config.stopCmd", "pkill -f serviceAbbr.jar");
        this.loadConfig("config.dataCenters", "dc", this.config.dataCenters);
        this.loadConfig("config.networks", "prd, tst", this.config.networks);
        this.loadConfig("config.envs", "Java7, Java8, NodeJS", this.config.envs);
        this.loadConfig("config.sizes", "S, M, L, XL", this.config.sizes);
        this.loadConfig("config.protocols", "HTTP, HTTPS, TCP", this.config.protocols);
        this.loadConfig("config.domains", "northernwall.com", this.config.domains);
        this.loadConfig("config.artifactTypes", "jar, war, targz", this.config.artifactTypes);
        this.loadConfig("config.templates", "Java template", this.config.templates);
        this.config.serviceTypes.add("Service");
        this.config.serviceTypes.add("Shared Library");
        this.config.gitModes.add("Consolidated");
        this.config.gitModes.add("Flat");
        this.config.moduleTypes.add("Deployable");
        this.config.moduleTypes.add("Library");
        this.config.moduleTypes.add("Test");
    }

    private void setupJetty() {
        this.port = this.parameters.getInt("jetty.port", 9090);
        this.server = new Server((ThreadPool)new QueuedThreadPool(10, 5));
        this.server.setStopAtShutdown(true);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{httpFactory});
        connector.setPort(this.port);
        connector.setIdleTimeout((long)this.parameters.getInt("jetty.idleTimeout", 1000));
        connector.setAcceptQueueSize(this.parameters.getInt("jetty.idleTimeout", 100));
        this.server.addConnector((Connector)connector);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)new AvailabilityHandler(this.accessHandler, this.dataAccess, this.mavenHelper));
        handlers.addHandler((Handler)new ContentHandler("/webcontent"));
        handlers.addHandler((Handler)new WorkItemCallbackHandler(this.workItemProcess));
        handlers.addHandler((Handler)new AuditHandler(this.dataAccess));
        handlers.addHandler(this.accessHandler);
        handlers.addHandler((Handler)new ContentHandler("/webapp"));
        handlers.addHandler((Handler)new TreeHandler(this.dataAccess));
        handlers.addHandler((Handler)new UserHandler(this.accessHelper, this.dataAccess));
        handlers.addHandler((Handler)new TeamHandler(this.accessHelper, this.dataAccess));
        handlers.addHandler((Handler)new ServiceHandler(this.accessHelper, this.dataAccess, this.workItemProcess, this.config, this.mavenHelper, this.infoHelper));
        handlers.addHandler((Handler)new VipHandler(this.accessHelper, this.dataAccess, this.workItemProcess));
        handlers.addHandler((Handler)new ModuleHandler(this.accessHelper, this.config, this.dataAccess, this.workItemProcess));
        handlers.addHandler((Handler)new HostHandler(this.accessHelper, this.config, this.dataAccess, this.workItemProcess, this.hostDetailsHelper));
        handlers.addHandler((Handler)new CustomFuntionHandler(this.accessHelper, this.dataAccess, this.client));
        handlers.addHandler((Handler)new WorkItemHandler(this.dataAccess));
        handlers.addHandler((Handler)new DataStoreHandler(this.accessHelper, this.dataAccess));
        handlers.addHandler((Handler)new ConfigHandler(this.config));
        handlers.addHandler((Handler)new CalendarHandler(this.dataAccess, this.calendarHelper));
        handlers.addHandler((Handler)new GraphHandler(this.dataAccess));
        handlers.addHandler((Handler)new RedirectHandler());
        MetricHandler metricHandler = new MetricHandler(handlers, this.metricRegistry);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setHandler((Handler)metricHandler);
        contextHandler.setContextPath("/");
        this.server.setHandler((Handler)contextHandler);
    }

    public void start() {
        try {
            this.server.start();
            logger.info("Jetty server started on port {}, joining with server thread now", (Object)this.port);
            this.server.join();
        }
        catch (BindException be) {
            logger.error("Can not bind to port {}, exiting", (Object)this.port);
            System.exit(0);
        }
        catch (Exception ex) {
            logger.error("Exception {} occured", (Object)ex.getMessage());
        }
    }
}

