/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.EachTestNotifierInit;
import com.nordstrom.automation.junit.JUnitWatcher;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.RunWatcher;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunListener.ThreadSafe
public class RunAnnouncer
extends RunListener
implements JUnitWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunAnnouncer.class);

    public void testStarted(Description description) throws Exception {
        LOGGER.debug("testStarted: {}", (Object)description);
        AtomicTest atomicTest = RunAnnouncer.ensureAtomicTestOf(description);
        for (RunWatcher watcher : LifecycleHooks.getRunWatchers()) {
            watcher.testStarted(atomicTest);
        }
    }

    public void testFinished(Description description) throws Exception {
        LOGGER.debug("testFinished: {}", (Object)description);
        AtomicTest atomicTest = RunAnnouncer.ensureAtomicTestOf(description);
        for (RunWatcher watcher : LifecycleHooks.getRunWatchers()) {
            watcher.testFinished(atomicTest);
        }
    }

    public void testFailure(Failure failure) throws Exception {
        LOGGER.debug("testFailure: {}", (Object)failure);
        AtomicTest atomicTest = RunAnnouncer.ensureAtomicTestOf(failure);
        for (RunWatcher watcher : LifecycleHooks.getRunWatchers()) {
            watcher.testFailure(atomicTest, failure.getException());
        }
    }

    public void testAssumptionFailure(Failure failure) {
        LOGGER.debug("testAssumptionFailure: {}", (Object)failure);
        AtomicTest atomicTest = RunAnnouncer.ensureAtomicTestOf(failure);
        for (RunWatcher watcher : LifecycleHooks.getRunWatchers()) {
            watcher.testAssumptionFailure(atomicTest, (AssumptionViolatedException)failure.getException());
        }
    }

    public void testIgnored(Description description) throws Exception {
        LOGGER.debug("testIgnored: {}", (Object)description);
        AtomicTest atomicTest = RunAnnouncer.ensureAtomicTestOf(description);
        for (RunWatcher watcher : LifecycleHooks.getRunWatchers()) {
            watcher.testIgnored(atomicTest);
        }
    }

    private static AtomicTest ensureAtomicTestOf(Description description) {
        AtomicTest atomicTest = EachTestNotifierInit.getAtomicTestOf(description);
        if (atomicTest == null) {
            atomicTest = new AtomicTest(description);
        }
        return atomicTest;
    }

    private static AtomicTest ensureAtomicTestOf(Failure failure) {
        AtomicTest atomicTest = EachTestNotifierInit.getAtomicTestOf(failure.getDescription());
        if (atomicTest == null) {
            atomicTest = new AtomicTest(failure.getDescription());
            atomicTest.setThrowable(failure.getException());
        }
        return atomicTest;
    }
}

