/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.AnnotationsAccessor;
import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.MutableTest;
import com.nordstrom.automation.junit.RetriedTheory;
import com.nordstrom.automation.junit.UniqueIdAccessor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Objects;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.theories.Theory;
import org.junit.runner.Description;

@Ignore
public class RetriedTest
extends MutableTest {
    private final Throwable thrown;

    protected RetriedTest(Test annotation, Throwable thrown) {
        super(annotation);
        this.thrown = Objects.requireNonNull(thrown, "[thrown] must be non-null");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Test.class;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    @Override
    public String toString() {
        return super.toString().replaceAll(".$", "") + ", thrown=" + this.thrown.getClass().getName() + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.thrown == null ? 0 : this.thrown.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RetriedTest)) {
            return false;
        }
        RetriedTest other = (RetriedTest)obj;
        return !(this.thrown == null ? other.thrown != null : !this.thrown.equals(other.thrown));
    }

    public static boolean isRetriedTest(Description description) {
        Annotation annotation = AtomicTest.getTestAnnotation(description);
        return annotation instanceof RetriedTest || annotation instanceof RetriedTheory;
    }

    static Description proxyFor(Description description, Throwable thrown) {
        Object proxy = null;
        Annotation annotation = AtomicTest.getTestAnnotation(description);
        if (annotation == null) {
            throw new IllegalArgumentException("Specified method is not a JUnit @Test or @Theory: " + description);
        }
        proxy = annotation.annotationType().equals(Test.class) ? new RetriedTest((Test)annotation, thrown) : new RetriedTheory((Theory)annotation, thrown);
        RetriedTest.injectProxy(description, (Annotation)proxy);
        return RetriedTest.duplicate(description);
    }

    private static void injectProxy(Description description, Annotation proxyAnnotation) {
        Annotation[] annotations = ((AnnotationsAccessor)description).annotations();
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].annotationType().equals(proxyAnnotation.annotationType())) continue;
            annotations[i] = proxyAnnotation;
            break;
        }
    }

    private static Description duplicate(Description description) {
        String displayName = description.getDisplayName();
        Serializable uniqueId = ((UniqueIdAccessor)description).getUniqueId();
        Annotation[] annotations = ((AnnotationsAccessor)description).annotations();
        return Description.createSuiteDescription((String)displayName, (Serializable)uniqueId, (Annotation[])annotations);
    }
}

