/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.EachTestNotifierInit;
import com.nordstrom.automation.junit.Hooked;
import com.nordstrom.automation.junit.JUnitConfig;
import com.nordstrom.automation.junit.JUnitWatcher;
import com.nordstrom.automation.junit.MethodWatcher;
import com.nordstrom.automation.junit.Run;
import com.nordstrom.automation.junit.RunReflectiveCall;
import com.nordstrom.automation.junit.RunWatcher;
import com.nordstrom.automation.junit.RunnerWatcher;
import com.nordstrom.automation.junit.ShutdownListener;
import com.nordstrom.automation.junit.TestObjectWatcher;
import com.nordstrom.common.base.UncheckedThrow;
import com.nordstrom.common.file.PathUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.TestClass;

public class LifecycleHooks {
    private static JUnitConfig config;
    private static final List<JUnitWatcher> watchers;
    private static final List<RunListener> runListeners;
    private static final List<RunWatcher> runWatchers;
    private static final List<RunnerWatcher> runnerWatchers;
    private static final List<TestObjectWatcher> objectWatchers;
    private static final List<MethodWatcher<?>> methodWatchers;

    private LifecycleHooks() {
        throw new AssertionError((Object)"LifecycleHooks is a static utility class that cannot be instantiated");
    }

    static Thread getShutdownHook(final ShutdownListener listener) {
        return new Thread(){

            @Override
            public void run() {
                listener.onShutdown();
            }
        };
    }

    static synchronized JUnitConfig getConfig() {
        if (config == null) {
            config = JUnitConfig.getConfig();
        }
        return config;
    }

    public static AtomicTest getAtomicTestOf(Object target) {
        return EachTestNotifierInit.getAtomicTestOf(target);
    }

    public static Object getParentOf(Object child) {
        return Run.getParentOf(child);
    }

    public static Object getNotifierOf(Object runner) {
        return Run.getNotifierOf(runner);
    }

    public static Object getThreadRunner() {
        return Run.getThreadRunner();
    }

    public static TestClass getTestClassOf(Object runner) {
        return (TestClass)LifecycleHooks.invoke(runner, "getTestClass", new Object[0]);
    }

    public static AtomicTest getAtomicTestOf(Description description) {
        return EachTestNotifierInit.getAtomicTestOf(description);
    }

    public static Object getTargetOf(Description description) {
        return EachTestNotifierInit.getTargetOf(description);
    }

    public static Description describeChild(Object runner, Object child) {
        Class<?> runnerType;
        if (runner != null && child != null && (runnerType = LifecycleHooks.getSupportedType(runner)) != null && runnerType.isInstance(child)) {
            return (Description)LifecycleHooks.invoke(runner, "describeChild", child);
        }
        return null;
    }

    private static Class<?> getSupportedType(Object runner) {
        for (Method method : runner.getClass().getDeclaredMethods()) {
            Class<?>[] paramTypes;
            if (!"describeChild".equals(method.getName()) || (paramTypes = method.getParameterTypes()).length != 1 || paramTypes[0] == Object.class) continue;
            return paramTypes[0];
        }
        return null;
    }

    public static ReflectiveCallable getCallableOf(Description description) {
        return RunReflectiveCall.getCallableOf(description);
    }

    public static ReflectiveCallable encloseCallable(final Method method, final Object target, final Object ... params) {
        return new ReflectiveCallable(){

            protected Object runReflectiveCall() throws Throwable {
                return method.invoke(target, params);
            }
        };
    }

    public static Class<?> getInstanceClass(Object instance) {
        Class<?> clazz = instance.getClass();
        return instance instanceof Hooked ? clazz.getSuperclass() : clazz;
    }

    static String getSubclassName(Object testObj) {
        Class<?> testClass = testObj.getClass();
        String testClassName = testClass.getSimpleName();
        String testPackageName = testClass.getPackage().getName();
        PathUtils.ReportsDirectory constant = PathUtils.ReportsDirectory.fromObject((Object)testObj);
        switch (constant) {
            case FAILSAFE_2: 
            case FAILSAFE_3: 
            case SUREFIRE_2: 
            case SUREFIRE_3: 
            case SUREFIRE_4: {
                return testPackageName + ".Hooked" + testClassName;
            }
        }
        return testClass.getCanonicalName() + "Hooked";
    }

    static <T> T invoke(Object target, String methodName, Object ... parameters) {
        try {
            return (T)MethodUtils.invokeMethod((Object)target, (boolean)true, (String)methodName, (Object[])parameters);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw UncheckedThrow.throwUnchecked((Throwable)e);
        }
    }

    static Field getDeclaredField(Object target, String name) throws NoSuchFieldException {
        Exception thrown = null;
        for (Class<?> current = target.getClass(); current != null; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                thrown = e;
                continue;
            }
            catch (SecurityException e) {
                thrown = e;
                break;
            }
        }
        throw UncheckedThrow.throwUnchecked(thrown);
    }

    public static <T> T getFieldValue(Object target, String name) throws IllegalAccessException, NoSuchFieldException, SecurityException {
        Field field = LifecycleHooks.getDeclaredField(target, name);
        field.setAccessible(true);
        return (T)field.get(target);
    }

    static <T> T callProxy(Callable<?> proxy) throws Exception {
        try {
            return (T)proxy.call();
        }
        catch (InvocationTargetException e) {
            throw UncheckedThrow.throwUnchecked((Throwable)e.getCause());
        }
    }

    public static <T extends JUnitWatcher> Optional<T> getAttachedWatcher(Class<T> watcherType) {
        for (JUnitWatcher watcher : watchers) {
            if (watcher.getClass() != watcherType) continue;
            return Optional.of((Object)watcher);
        }
        return Optional.absent();
    }

    public static <T extends RunListener> Optional<T> getAttachedListener(Class<T> listenerType) {
        Optional<T> optListener = LifecycleHooks.findListener(listenerType, runListeners);
        if (!optListener.isPresent()) {
            optListener = LifecycleHooks.findListener(listenerType, LifecycleHooks.getAttachedListeners());
        }
        return optListener;
    }

    private static List<RunListener> getAttachedListeners() {
        Object notifier;
        Object runner = LifecycleHooks.getThreadRunner();
        if (runner != null && (notifier = LifecycleHooks.getNotifierOf(runner)) != null) {
            try {
                return (List)LifecycleHooks.getFieldValue(notifier, "listeners");
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        return new ArrayList<RunListener>();
    }

    private static <T extends RunListener> Optional<T> findListener(Class<T> type, List<RunListener> list) {
        for (RunListener listener : list) {
            if (listener.getClass() != type) continue;
            return Optional.of((Object)listener);
        }
        return Optional.absent();
    }

    static <K, T> T computeIfAbsent(ConcurrentMap<K, T> map, K key, Function<K, T> fun) {
        Object val = map.get(key);
        if (val == null) {
            Object obj = fun.apply(key);
            val = map.putIfAbsent(key, obj);
            val = val == null ? obj : val;
        }
        return (T)val;
    }

    static List<RunListener> getRunListeners() {
        return runListeners;
    }

    static List<RunWatcher> getRunWatchers() {
        return runWatchers;
    }

    static List<RunnerWatcher> getRunnerWatchers() {
        return runnerWatchers;
    }

    static List<TestObjectWatcher> getObjectWatchers() {
        return objectWatchers;
    }

    static List<MethodWatcher<?>> getMethodWatchers() {
        return methodWatchers;
    }

    static String toMapKey(Object obj) {
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    static {
        WatcherClassifier classifier = new WatcherClassifier();
        for (JUnitWatcher jUnitWatcher : ServiceLoader.load(JUnitWatcher.class)) {
            classifier.add(jUnitWatcher);
        }
        for (RunListener runListener : ServiceLoader.load(RunListener.class)) {
            classifier.add(runListener);
        }
        for (ShutdownListener shutdownListener : ServiceLoader.load(ShutdownListener.class)) {
            classifier.add(shutdownListener);
        }
        for (RunWatcher runWatcher : ServiceLoader.load(RunWatcher.class)) {
            classifier.add(runWatcher);
        }
        for (RunnerWatcher runnerWatcher : ServiceLoader.load(RunnerWatcher.class)) {
            classifier.add(runnerWatcher);
        }
        for (TestObjectWatcher testObjectWatcher : ServiceLoader.load(TestObjectWatcher.class)) {
            classifier.add(testObjectWatcher);
        }
        for (MethodWatcher methodWatcher : ServiceLoader.load(MethodWatcher.class)) {
            classifier.add(methodWatcher);
        }
        watchers = classifier.watchers;
        runListeners = classifier.listeners;
        runWatchers = new WatcherList<RunWatcher>(classifier.runWatcherIndexes);
        runnerWatchers = new WatcherList<RunnerWatcher>(classifier.runnerWatcherIndexes);
        objectWatchers = new WatcherList<TestObjectWatcher>(classifier.objectWatcherIndexes);
        methodWatchers = new WatcherList(classifier.methodWatcherIndexes);
    }

    private static class WatcherList<T extends JUnitWatcher>
    extends AbstractList<T> {
        private int[] indexes;

        private WatcherList(List<Integer> indexes) {
            int i = 0;
            this.indexes = new int[indexes.size()];
            for (int index : indexes) {
                this.indexes[i++] = index;
            }
        }

        @Override
        public T get(int index) {
            return (T)((JUnitWatcher)watchers.get(this.indexes[index]));
        }

        @Override
        public int size() {
            return this.indexes.length;
        }
    }

    private static class WatcherClassifier {
        int i = 0;
        List<JUnitWatcher> watchers = new ArrayList<JUnitWatcher>();
        List<Class<? extends JUnitWatcher>> watcherClasses = new ArrayList<Class<? extends JUnitWatcher>>();
        List<RunListener> listeners = new ArrayList<RunListener>();
        List<Class<? extends RunListener>> listenerClasses = new ArrayList<Class<? extends RunListener>>();
        List<Integer> runWatcherIndexes = new ArrayList<Integer>();
        List<Integer> runnerWatcherIndexes = new ArrayList<Integer>();
        List<Integer> objectWatcherIndexes = new ArrayList<Integer>();
        List<Integer> methodWatcherIndexes = new ArrayList<Integer>();

        private WatcherClassifier() {
        }

        boolean add(JUnitWatcher watcher) {
            if (!this.watcherClasses.contains(watcher.getClass())) {
                this.watchers.add(watcher);
                this.watcherClasses.add(watcher.getClass());
                if (watcher instanceof RunListener) {
                    this.add((RunListener)watcher);
                }
                if (watcher instanceof ShutdownListener) {
                    Runtime.getRuntime().addShutdownHook(LifecycleHooks.getShutdownHook((ShutdownListener)watcher));
                }
                if (watcher instanceof RunWatcher) {
                    this.runWatcherIndexes.add(this.i);
                }
                if (watcher instanceof RunnerWatcher) {
                    this.runnerWatcherIndexes.add(this.i);
                }
                if (watcher instanceof TestObjectWatcher) {
                    this.objectWatcherIndexes.add(this.i);
                }
                if (watcher instanceof MethodWatcher) {
                    this.methodWatcherIndexes.add(this.i);
                }
                ++this.i;
                return true;
            }
            return false;
        }

        boolean add(RunListener listener) {
            if (!this.listenerClasses.contains(listener.getClass())) {
                this.listeners.add(listener);
                this.listenerClasses.add(listener.getClass());
                return true;
            }
            return false;
        }
    }
}

