/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.UniqueIdAccessor;
import com.nordstrom.automation.junit.UniqueIdMutator;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.experimental.theories.internal.Assignments;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;

public class DescribeChild {
    private static final String PERM_TAG = "theory-id: ";

    public static Description intercept(@This Object runner, @SuperCall Callable<?> proxy, @Argument(value=0) Object child) throws Exception {
        Description description = null;
        try {
            description = (Description)LifecycleHooks.callProxy(proxy);
        }
        catch (NullPointerException eaten) {
            FrameworkMethod method = (FrameworkMethod)child;
            description = Description.createTestDescription((Class)method.getDeclaringClass(), (String)method.getName(), (Annotation[])method.getAnnotations());
        }
        if (description.getAnnotation(Theory.class) != null && !DescribeChild.isPermutation(description)) {
            try {
                Assignments assignments;
                String permutationId;
                Object parent = LifecycleHooks.getFieldValue(runner, "this$0");
                if (parent instanceof Theories.TheoryAnchor && (permutationId = DescribeChild.computePermutationId(description, assignments = (Assignments)LifecycleHooks.getFieldValue(runner, "val$complete"))) != null) {
                    ((UniqueIdMutator)description).setUniqueId((Serializable)((Object)permutationId));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        return description;
    }

    static boolean isPermutation(Description description) {
        return ((UniqueIdAccessor)description).getUniqueId().toString().startsWith(PERM_TAG);
    }

    private static String computePermutationId(Description description, Assignments assignments) {
        try {
            Object[] args = assignments.getMethodArguments();
            Object[] perm = new Object[args.length + 1];
            perm[0] = description.getDisplayName();
            System.arraycopy(args, 0, perm, 1, args.length);
            int permutationId = Arrays.hashCode(perm);
            return String.format("theory-id: %08X", permutationId);
        }
        catch (PotentialAssignment.CouldNotGenerateValueException e) {
            return null;
        }
    }
}

