/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.google.common.base.Function;
import com.nordstrom.automation.junit.DepthGauge;
import com.nordstrom.automation.junit.EachTestNotifierInit;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.TestObjectWatcher;
import com.nordstrom.automation.junit.TimeoutUtils;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.runners.model.FrameworkMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTest {
    private static final Map<Integer, Object> HASHCODE_TO_TARGET = new ConcurrentHashMap<Integer, Object>();
    private static final Map<String, FrameworkMethod> TARGET_TO_METHOD = new ConcurrentHashMap<String, FrameworkMethod>();
    private static final Map<String, Object> TARGET_TO_RUNNER = new ConcurrentHashMap<String, Object>();
    private static final ThreadLocal<ConcurrentMap<Integer, DepthGauge>> METHOD_DEPTH;
    private static final Function<Integer, DepthGauge> NEW_INSTANCE;
    private static final Logger LOGGER;

    @RuntimeType
    public static Object intercept(@This Object runner, @Argument(value=0) FrameworkMethod method, @SuperCall Callable<?> proxy) throws Exception {
        Integer hashCode = Objects.hash(runner, method.toString());
        DepthGauge depthGauge = LifecycleHooks.computeIfAbsent(METHOD_DEPTH.get(), hashCode, NEW_INSTANCE);
        depthGauge.increaseDepth();
        Object target = LifecycleHooks.callProxy(proxy);
        if (0 == depthGauge.decreaseDepth()) {
            METHOD_DEPTH.get().remove(hashCode);
            LOGGER.debug("testObjectCreated: {}", target);
            TARGET_TO_METHOD.put(LifecycleHooks.toMapKey(target), method);
            TARGET_TO_RUNNER.put(LifecycleHooks.toMapKey(target), runner);
            TimeoutUtils.applyTestTimeout(runner, method, target);
            if (!EachTestNotifierInit.setTestTarget(runner, method, target)) {
                HASHCODE_TO_TARGET.put(hashCode, target);
            }
            for (TestObjectWatcher watcher : LifecycleHooks.getObjectWatchers()) {
                watcher.testObjectCreated(runner, method, target);
            }
        }
        return target;
    }

    static Object getTargetFor(Object runner, FrameworkMethod method) {
        return HASHCODE_TO_TARGET.remove(Objects.hash(runner, method.toString()));
    }

    static FrameworkMethod getMethodFor(Object target) {
        return TARGET_TO_METHOD.get(LifecycleHooks.toMapKey(target));
    }

    static Object getRunnerFor(Object target) {
        return TARGET_TO_RUNNER.get(LifecycleHooks.toMapKey(target));
    }

    static void releaseMappingsFor(Object runner, FrameworkMethod method, Object target) {
        HASHCODE_TO_TARGET.remove(Objects.hash(runner, method.toString()));
        if (target != null) {
            TARGET_TO_METHOD.remove(LifecycleHooks.toMapKey(target));
            TARGET_TO_RUNNER.remove(LifecycleHooks.toMapKey(target));
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(CreateTest.class);
        METHOD_DEPTH = new ThreadLocal<ConcurrentMap<Integer, DepthGauge>>(){

            @Override
            protected ConcurrentMap<Integer, DepthGauge> initialValue() {
                return new ConcurrentHashMap<Integer, DepthGauge>();
            }
        };
        NEW_INSTANCE = new Function<Integer, DepthGauge>(){

            public DepthGauge apply(Integer input) {
                return new DepthGauge();
            }
        };
    }
}

