package com.noisyz.bindlibrary.wrappers.view.simple.text;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.TextView;

import com.noisyz.bindlibrary.wrappers.ViewBinder;

/**
 * Created by nero232 on 12.06.17.
 */

public abstract class BaseTextWrapper<T> extends ViewBinder<T, TextView> implements TextWatcher {
    @Override
    public void bindUI(T t, TextView textView) {
        textView.setText(String.valueOf(t));
    }

    @Override
    public void addListeners(TextView textView) {
        textView.addTextChangedListener(this);
    }

    @Override
    public void removeListeners(TextView textView) {
        textView.removeTextChangedListener(this);
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {

    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {

    }

    @Override
    public void afterTextChanged(Editable s) {
        bindByValueFromText(s.toString());
    }

    protected abstract void bindByValueFromText(String text);
}
