/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.noisyz.bindlibrary.base.impl.ObjectViewBinder;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListenerWrapper;
import com.noisyz.bindlibrary.callback.clickevent.OnItemClickListener;
import java.util.List;

public class BindViewHolder<T>
extends RecyclerView.ViewHolder {
    private ObjectViewBinder<T> objectViewBinder;

    public BindViewHolder(View itemView, ObjectViewBinder<T> objectViewBinder, boolean clearEmptyBinders) {
        super(itemView);
        this.objectViewBinder = objectViewBinder;
        objectViewBinder.registerView(itemView);
        if (clearEmptyBinders) {
            objectViewBinder.clearEmptyBinders();
        }
    }

    public void bindView(final T t, final OnItemClickListener<T> onItemClickListener, List<OnElementClickListenerWrapper<T>> elementsClickWrappers) {
        this.objectViewBinder.setBindObject(t);
        this.objectViewBinder.bindUI();
        View finalView = this.itemView;
        if (onItemClickListener != null) {
            finalView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    onItemClickListener.onItemClick(v, BindViewHolder.this.getAdapterPosition(), t);
                }
            });
        }
        if (elementsClickWrappers != null && !elementsClickWrappers.isEmpty()) {
            for (final OnElementClickListenerWrapper<T> wrapper : elementsClickWrappers) {
                for (final int elementId : wrapper.getIds()) {
                    View element = finalView.findViewById(elementId);
                    if (element == null) continue;
                    element.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            wrapper.getOnClickListener().onElementClick(v, elementId, BindViewHolder.this.getAdapterPosition(), t);
                        }
                    });
                }
            }
        }
    }
}

