package com.noisyz.bindlibrary.base.impl.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.noisyz.bindlibrary.base.impl.ObjectViewBinder;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListenerWrapper;
import com.noisyz.bindlibrary.callback.clickevent.OnItemClickListener;

import java.util.List;

/**
 * Created by nero232 on 06.05.17.
 */

public class BindViewHolder<T> extends RecyclerView.ViewHolder {

    private ObjectViewBinder<T> objectViewBinder;

    public BindViewHolder(View itemView, ObjectViewBinder<T> objectViewBinder, boolean clearEmptyBinders) {
        super(itemView);
        this.objectViewBinder = objectViewBinder;
        objectViewBinder.registerView(itemView);
        if (clearEmptyBinders)
            objectViewBinder.clearEmptyBinders();
    }

    public void bindView(final T t, final OnItemClickListener<T> onItemClickListener,
                         final List<OnElementClickListenerWrapper<T>> elementsClickWrappers) {
        objectViewBinder.setBindObject(t);
        objectViewBinder.bindUI();

        View finalView = itemView;
        if (onItemClickListener != null) {
            finalView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onItemClickListener.onItemClick(v, getAdapterPosition(), t);
                }
            });
        }

        if (elementsClickWrappers != null && !elementsClickWrappers.isEmpty()) {
            for (final OnElementClickListenerWrapper<T> wrapper : elementsClickWrappers)
                for (final int elementId : wrapper.getIds()) {
                    View element = finalView.findViewById(elementId);
                    if (element != null) {
                        element.setOnClickListener(new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                wrapper.getOnClickListener().onElementClick(v, elementId,
                                        getAdapterPosition(), t);
                            }
                        });
                    }
                }
        }
    }
}
