package com.noisyz.bindlibrary.wrappers.view.simple.text;

import android.widget.TextView;

import com.noisyz.bindlibrary.wrappers.IViewBinder;

/**
 * Created by nero232 on 28.04.17.
 */

public class FormattedTextViewWrapper implements IViewBinder<FormattedText, TextView> {
    @Override
    public void bindUI(FormattedText formattedText, TextView textView) {
        if (formattedText.getStringResourceId() != 0) {
            String unformattedString = textView.getResources().getString(formattedText.getStringResourceId());
            textView.setText(String.format(unformattedString, formattedText.getValue()));
        }
    }
}
