package com.noisyz.bindlibrary.base.impl.adapter;


import android.util.Log;

import com.noisyz.bindlibrary.base.impl.ObjectViewBinder;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListener;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListenerWrapper;
import com.noisyz.bindlibrary.callback.clickevent.OnItemClickListener;
import com.noisyz.bindlibrary.callback.filter.ItemFilterCallback;
import com.noisyz.bindlibrary.callback.filter.ItemsFilter;
import com.noisyz.bindlibrary.callback.layoutcallback.LayoutResourceProvider;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by oleg on 06.09.16.
 */
public abstract class RecyclerFilterableBindAdapter<T, V> extends RecyclerBindAdapter<T> implements ItemsFilter<V> {

    private List<T> filteredList;
    private ItemFilterCallback<T, V> itemFilterCallback;

    public RecyclerFilterableBindAdapter(List<T> itemList, int layoutResID,
                                         ItemFilterCallback<T, V> itemFilterCallback) {
        super(itemList, layoutResID);
        this.itemFilterCallback = itemFilterCallback;
    }

    public RecyclerFilterableBindAdapter(List<T> itemList, LayoutResourceProvider<T> mLayoutResourceProvider,
                                         ItemFilterCallback<T, V> itemFilterCallback) {
        super(itemList, mLayoutResourceProvider);
        this.itemFilterCallback = itemFilterCallback;
    }

    @Override
    public int getItemCount() {
        List<T> list = getItems();
        return list != null ? list.size() : 0;
    }

    public T getItem(int position) {
        List<T> list = getItems();
        return list != null ? list.get(position) : null;
    }

    @Override
    public List<T> getItems() {
        return itemFilterCallback != null && filteredList != null ? filteredList : super.getItems();
    }

    public RecyclerFilterableBindAdapter<T, V> setOnElementClickListener(int elementId, OnElementClickListener<T> onClickListener) {
        super.setOnElementClickListener(elementId, onClickListener);
        return this;
    }

    public RecyclerFilterableBindAdapter<T, V> setOnElementsClickListener(OnElementClickListener<T> onClickListener, int... elementIds) {
        super.setOnElementsClickListener(onClickListener, elementIds);
        return this;
    }

    public RecyclerFilterableBindAdapter<T, V> setOnItemClickListener(OnItemClickListener<T> onItemClickListener) {
        super.setOnItemClickListener(onItemClickListener);
        return this;
    }

    @Override
    public void filter(V v) {
        if (itemFilterCallback != null) {
            List<T> filteredList = new ArrayList<>();
            for (T t : super.getItems()) {
                if (v == null || itemFilterCallback.filterBy(t, v))
                    filteredList.add(t);
            }
            this.filteredList = filteredList;
            notifyDataSetChanged();
        }
    }

    @Override
    public void setItems(List<T> items) {
        super.setItems(items);
        restore();
    }

    @Override
    public void restore() {
        filter(null);
    }
}
