package com.noisyz.bindlibrary.wrappers.view.simple.text;

import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.widget.TextView;

import com.noisyz.bindlibrary.wrappers.ViewBinder;

/**
 * Created by Oleg on 18.03.2016.
 */
public class IntegerTextWrapper extends ViewBinder<Integer, TextView> implements TextWatcher {

    @Override
    public void addListeners(TextView textView) {
        textView.setInputType(InputType.TYPE_CLASS_NUMBER);
        textView.addTextChangedListener(this);
    }

    @Override
    public void removeListeners(TextView textView) {
        textView.removeTextChangedListener(this);
    }

    @Override
    public Integer getViewValue(TextView textView) {
        return Integer.parseInt(textView.getText().toString());
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

    }

    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

    }

    @Override
    public void afterTextChanged(Editable editable) {
        Integer value = Integer.valueOf(editable.toString());
        bindObject(value);
    }

    @Override
    public void bindUI(Integer integer, TextView textView) {
        textView.setText(String.valueOf(integer));
    }
}
