/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.noisyz.bindlibrary.base.impl.ObjectViewBinder;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListener;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListenerWrapper;
import com.noisyz.bindlibrary.callback.clickevent.OnItemClickListener;
import com.noisyz.bindlibrary.callback.layoutcallback.EmptyBaseLayoutResourceProvider;
import com.noisyz.bindlibrary.callback.layoutcallback.LayoutResourceProvider;
import java.util.ArrayList;
import java.util.List;

public abstract class RecyclerBindAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private List<T> itemList;
    private LayoutResourceProvider<T> mLayoutResourceProvider;
    private OnItemClickListener<T> onItemClickListener;
    private List<OnElementClickListenerWrapper<T>> elementsClickWrappers;

    public RecyclerBindAdapter(List<T> itemList, int layoutResID) {
        this.mLayoutResourceProvider = new EmptyBaseLayoutResourceProvider(layoutResID);
        if (itemList == null) {
            itemList = new ArrayList<T>();
        }
        this.itemList = itemList;
        this.elementsClickWrappers = new ArrayList<OnElementClickListenerWrapper<T>>();
    }

    public RecyclerBindAdapter(List<T> itemList, LayoutResourceProvider<T> mLayoutResourceProvider) {
        this(mLayoutResourceProvider);
        if (itemList == null) {
            itemList = new ArrayList<T>();
        }
        this.itemList = itemList;
    }

    private RecyclerBindAdapter(LayoutResourceProvider<T> mLayoutResourceProvider) {
        this.mLayoutResourceProvider = mLayoutResourceProvider;
        this.elementsClickWrappers = new ArrayList<OnElementClickListenerWrapper<T>>();
    }

    public RecyclerBindAdapter setOnElementClickListener(int elementId, OnElementClickListener<T> onClickListener) {
        this.elementsClickWrappers.add(new OnElementClickListenerWrapper<T>(elementId, onClickListener));
        return this;
    }

    public RecyclerBindAdapter setOnElementsClickListener(OnElementClickListener<T> onClickListener, int ... elementIds) {
        this.elementsClickWrappers.add(new OnElementClickListenerWrapper<T>(elementIds, onClickListener));
        return this;
    }

    public RecyclerBindAdapter setOnItemClickListener(OnItemClickListener<T> onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
        return this;
    }

    public BindViewHolder onCreateViewHolder(ViewGroup parent, int itemViewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        return new BindViewHolder(inflater.inflate(this.mLayoutResourceProvider.getLayoutResourceID(itemViewType), parent, false));
    }

    public int getItemViewType(int position) {
        return this.mLayoutResourceProvider.getItemViewType(this.getItem(position));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        T t = this.getItem(position);
        BindViewHolder bindViewHolder = (BindViewHolder)holder;
        bindViewHolder.bindView(t);
        final View finalView = bindViewHolder.itemView;
        if (this.onItemClickListener != null) {
            finalView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RecyclerBindAdapter.this.onItemClickListener.onItemClick(finalView, position, RecyclerBindAdapter.this.getItem(position));
                }
            });
        }
        if (this.elementsClickWrappers != null && !this.elementsClickWrappers.isEmpty()) {
            for (final OnElementClickListenerWrapper<T> wrapper : this.elementsClickWrappers) {
                for (final int elementId : wrapper.getIds()) {
                    View element = finalView.findViewById(elementId);
                    if (element == null) continue;
                    element.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            wrapper.getOnClickListener().onElementClick(finalView, elementId, position, RecyclerBindAdapter.this.getItem(position));
                        }
                    });
                }
            }
        }
    }

    public int getItemCount() {
        return this.itemList != null ? this.itemList.size() : 0;
    }

    public T getItem(int position) {
        return this.itemList != null ? (T)this.itemList.get(position) : null;
    }

    public List<T> getItems() {
        return this.itemList;
    }

    public void setItems(List<T> items) {
        this.itemList = items;
        this.notifyDataSetChanged();
    }

    protected abstract ObjectViewBinder<T> initObjectViewBinder(T var1);

    private class BindViewHolder
    extends RecyclerView.ViewHolder {
        private ObjectViewBinder<T> objectViewBinder;

        public BindViewHolder(View itemView) {
            super(itemView);
        }

        public void bindView(T t) {
            if (this.objectViewBinder == null) {
                this.objectViewBinder = RecyclerBindAdapter.this.initObjectViewBinder(t).registerView(this.itemView);
            } else {
                this.objectViewBinder.registerView(this.itemView).setBindObject(t);
            }
            this.objectViewBinder.bindUI();
        }
    }
}

