/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.handler;

import com.noisyz.bindlibrary.annotation.Type;
import com.noisyz.bindlibrary.models.DefaultMethodWrapper;
import com.noisyz.bindlibrary.models.base.ClassWrapper;
import com.noisyz.bindlibrary.models.base.MethodItem;
import com.noisyz.bindlibrary.models.base.MethodWrapper;
import com.noisyz.bindlibrary.models.base.Primitive;
import com.noisyz.bindlibrary.models.key.Key;
import com.noisyz.bindlibrary.models.key.KeyManager;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class PrimitivesHandler {
    private static final List<Primitive> primitives = new ArrayList<Primitive>();

    private static Type getTypeOfPrimitiveMethod(String methodType) {
        for (Primitive primitive : primitives) {
            if (!methodType.equals(primitive.getName()) && !methodType.equals(primitive.getShortName())) continue;
            return primitive.getType();
        }
        return null;
    }

    private static String getReturnTypeOfPrimitiveMethod(Type type) {
        for (Primitive primitive : primitives) {
            if (!type.equals((Object)primitive.getType())) continue;
            return primitive.getName();
        }
        return null;
    }

    public void processPrimitives(ClassWrapper classWrapper, List<? extends ExecutableElement> elements) {
        for (int index = 0; index < elements.size(); ++index) {
            boolean processSuccessfully;
            ExecutableElement executableElement = elements.get(index);
            Key key = KeyManager.buildKeyFromElement(executableElement);
            if (key == null) continue;
            MethodWrapper methodWrapper = classWrapper.getMethodWrapper(key);
            Type type = PrimitivesHandler.getTypeOfElement(executableElement);
            if (type == null) continue;
            if (methodWrapper == null) {
                methodWrapper = new DefaultMethodWrapper(type);
            }
            boolean bl = processSuccessfully = PrimitivesHandler.processGetter(executableElement, methodWrapper) || PrimitivesHandler.processSetter(executableElement, methodWrapper);
            if (!processSuccessfully) continue;
            elements.remove(index);
            --index;
            classWrapper.putMethodWrapper(key, methodWrapper);
        }
    }

    private static boolean processGetter(ExecutableElement executableElement, MethodWrapper methodWrapper) {
        boolean success;
        MethodItem methodItem = PrimitivesHandler.buildGetterMethodItem(executableElement);
        boolean bl = success = methodItem != null;
        if (success) {
            methodWrapper.setGetter(methodItem);
        }
        return success;
    }

    private static boolean processSetter(ExecutableElement executableElement, MethodWrapper methodWrapper) {
        boolean success;
        MethodItem methodItem = PrimitivesHandler.buildSetterMethodItem(executableElement);
        boolean bl = success = methodItem != null;
        if (success) {
            methodWrapper.setSetter(methodItem);
        }
        return success;
    }

    public static Type getTypeOfElement(ExecutableElement executableElement) {
        VariableElement variableElement;
        String variableType;
        String returnType = executableElement.getReturnType().toString();
        Type type = PrimitivesHandler.getTypeOfPrimitiveMethod(returnType);
        if (type != null) {
            return type;
        }
        List<? extends VariableElement> variableElements = executableElement.getParameters();
        if (!variableElements.isEmpty() && variableElements.size() == 1 && (type = PrimitivesHandler.getTypeOfPrimitiveMethod(variableType = (variableElement = variableElements.get(0)).asType().toString())) != null) {
            return type;
        }
        return null;
    }

    public static MethodItem buildGetterMethodItem(ExecutableElement executableElement) {
        String returnType = executableElement.getReturnType().toString();
        Type type = PrimitivesHandler.getTypeOfPrimitiveMethod(returnType);
        if (type != null) {
            returnType = PrimitivesHandler.getReturnTypeOfPrimitiveMethod(type);
            return new MethodItem(executableElement.getSimpleName().toString(), returnType);
        }
        return null;
    }

    public static MethodItem buildSetterMethodItem(ExecutableElement executableElement) {
        VariableElement variableElement;
        String variableType;
        Type type;
        List<? extends VariableElement> variableElements = executableElement.getParameters();
        if (!variableElements.isEmpty() && variableElements.size() == 1 && (type = PrimitivesHandler.getTypeOfPrimitiveMethod(variableType = (variableElement = variableElements.get(0)).asType().toString())) != null) {
            variableType = PrimitivesHandler.getReturnTypeOfPrimitiveMethod(type);
            return new MethodItem(executableElement.getSimpleName().toString(), variableType);
        }
        return null;
    }

    static {
        primitives.add(new Primitive(Type.BOOLEAN, "java.lang.Boolean", "boolean"));
        primitives.add(new Primitive(Type.TEXT, "java.lang.String", "String"));
        primitives.add(new Primitive(Type.FLOAT_TEXT, "java.lang.Float", "float"));
        primitives.add(new Primitive(Type.DOUBLE_TEXT, "java.lang.Double", "double"));
        primitives.add(new Primitive(Type.TEXT_RES, "java.lang.Integer", "int"));
    }
}

