/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl.adapter.expandable;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import com.noisyz.bindlibrary.base.impl.ObjectViewBinder;
import com.noisyz.bindlibrary.callback.ChildrenProvider;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListener;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListenerWrapper;
import com.noisyz.bindlibrary.callback.clickevent.OnItemClickListener;
import java.util.ArrayList;
import java.util.List;

public class ExpandableBindAdapter
extends BaseExpandableListAdapter {
    protected List itemList;
    private OnItemClickListener onParentItemClickListener;
    private OnItemClickListener onChildItemClickListener;
    private List<OnElementClickListenerWrapper> parentElementsClickWrappers;
    private List<OnElementClickListenerWrapper> childElementsClickWrappers;
    private ChildrenProvider childrenProvider;
    private int parentLayoutID;
    private int childLayoutID;

    public ExpandableBindAdapter(List itemList, int parentLayoutID, int childLayoutID, ChildrenProvider childrenProvider) {
        this.itemList = itemList;
        this.parentLayoutID = parentLayoutID;
        this.childLayoutID = childLayoutID;
        this.childrenProvider = childrenProvider;
        this.parentElementsClickWrappers = new ArrayList<OnElementClickListenerWrapper>();
        this.childElementsClickWrappers = new ArrayList<OnElementClickListenerWrapper>();
    }

    public ExpandableBindAdapter setOnElementClickListener(int elementId, OnElementClickListener onClickListener) {
        this.parentElementsClickWrappers.add(new OnElementClickListenerWrapper(elementId, onClickListener));
        return this;
    }

    public ExpandableBindAdapter setOnElementsClickListener(OnElementClickListener onClickListener, int ... elementIds) {
        this.parentElementsClickWrappers.add(new OnElementClickListenerWrapper(elementIds, onClickListener));
        return this;
    }

    public ExpandableBindAdapter setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onParentItemClickListener = onItemClickListener;
        return this;
    }

    public ExpandableBindAdapter setOnChildElementClickListener(int elementId, OnElementClickListener onClickListener) {
        this.childElementsClickWrappers.add(new OnElementClickListenerWrapper(elementId, onClickListener));
        return this;
    }

    public ExpandableBindAdapter setOnChildElementsClickListener(OnElementClickListener onClickListener, int ... elementIds) {
        this.childElementsClickWrappers.add(new OnElementClickListenerWrapper(elementIds, onClickListener));
        return this;
    }

    public ExpandableBindAdapter setOnChildItemClickListener(OnItemClickListener onItemClickListener) {
        this.onChildItemClickListener = onItemClickListener;
        return this;
    }

    public int getGroupCount() {
        return this.itemList.size();
    }

    public int getChildrenCount(int position) {
        return this.childrenProvider.getChildren(this.itemList.get(position)).size();
    }

    public Object getGroup(int position) {
        return this.itemList.get(position);
    }

    public Object getChild(int groupPosition, int childPosition) {
        return this.childrenProvider.getChildren(this.itemList.get(childPosition)).size();
    }

    public long getGroupId(int i) {
        return 0L;
    }

    public long getChildId(int i, int i1) {
        return 0L;
    }

    public boolean hasStableIds() {
        return false;
    }

    public View getGroupView(final int position, boolean b, View view, ViewGroup viewGroup) {
        final Object object = this.itemList.get(position);
        BinderHolder binderHolder = null;
        if (view == null) {
            binderHolder = new BinderHolder();
            view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(this.parentLayoutID, null);
            binderHolder.objectViewBinder = new ObjectViewBinder(object).registerView(view);
            view.setTag((Object)binderHolder);
        } else {
            binderHolder = (BinderHolder)view.getTag();
            binderHolder.objectViewBinder.setObject(object);
        }
        binderHolder.objectViewBinder.bindUI();
        final View finalView = view;
        if (this.onParentItemClickListener != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ExpandableBindAdapter.this.onParentItemClickListener.onItemClick(finalView, position, object);
                }
            });
        }
        if (this.parentElementsClickWrappers != null && !this.parentElementsClickWrappers.isEmpty()) {
            for (final OnElementClickListenerWrapper wrapper : this.parentElementsClickWrappers) {
                for (final int elementId : wrapper.getIds()) {
                    View element = view.findViewById(elementId);
                    if (element == null) continue;
                    element.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            wrapper.getOnClickListener().onElementClick(finalView, elementId, position, object);
                        }
                    });
                }
            }
        }
        return view;
    }

    public View getChildView(int groupPosition, final int childPosition, boolean b, View view, ViewGroup viewGroup) {
        final Object object = this.getChild(groupPosition, childPosition);
        BinderHolder binderHolder = null;
        if (view == null) {
            binderHolder = new BinderHolder();
            view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(this.childLayoutID, null);
            binderHolder.objectViewBinder = new ObjectViewBinder(object).registerView(view);
            view.setTag((Object)binderHolder);
        } else {
            binderHolder = (BinderHolder)view.getTag();
            binderHolder.objectViewBinder.setObject(object);
        }
        binderHolder.objectViewBinder.bindUI();
        final View finalView = view;
        if (this.onChildItemClickListener != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ExpandableBindAdapter.this.onChildItemClickListener.onItemClick(finalView, childPosition, object);
                }
            });
        }
        if (this.childElementsClickWrappers != null && !this.childElementsClickWrappers.isEmpty()) {
            for (final OnElementClickListenerWrapper wrapper : this.childElementsClickWrappers) {
                for (final int elementId : wrapper.getIds()) {
                    View element = view.findViewById(elementId);
                    if (element == null) continue;
                    element.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            wrapper.getOnClickListener().onElementClick(finalView, elementId, childPosition, object);
                        }
                    });
                }
            }
        }
        return view;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return false;
    }

    static class BinderHolder {
        ObjectViewBinder objectViewBinder;

        BinderHolder() {
        }
    }
}

