/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl;

import com.noisyz.bindlibrary.base.ParentBinder;
import com.noisyz.bindlibrary.base.UIBinder;
import com.noisyz.bindlibrary.callback.DataUpdatedCallback;
import java.util.HashMap;

public class BindingManager
implements UIBinder,
ParentBinder {
    private HashMap<String, UIBinder> binders = new HashMap();
    private DataUpdatedCallback dataUpdatedCallback;

    public static BindingManager newInstance() {
        return new BindingManager();
    }

    private BindingManager() {
    }

    public UIBinder getBinder(String key) {
        return this.binders.get(key);
    }

    public BindingManager newBinder(String key, UIBinder uiBinder) {
        this.binders.put(key, uiBinder);
        if (this.hasDataUpdatedCallback() && !uiBinder.hasDataUpdatedCallback()) {
            uiBinder.setDataUpdatedCallback(this.getDataUpdatedCallback());
        }
        return this;
    }

    @Override
    public void bindUI() {
        for (String key : this.binders.keySet()) {
            this.binders.get(key).bindUI();
        }
    }

    @Override
    public BindingManager setDataUpdatedCallback(DataUpdatedCallback callback) {
        this.dataUpdatedCallback = callback;
        for (String key : this.binders.keySet()) {
            if (this.binders.get(key).hasDataUpdatedCallback()) continue;
            this.binders.get(key).setDataUpdatedCallback(callback);
        }
        return this;
    }

    @Override
    public DataUpdatedCallback getDataUpdatedCallback() {
        return this.dataUpdatedCallback;
    }

    @Override
    public boolean hasDataUpdatedCallback() {
        return this.dataUpdatedCallback != null;
    }

    @Override
    public void setObject(Object o) {
    }

    @Override
    public void release() {
        this.dataUpdatedCallback = null;
        for (String key : this.binders.keySet()) {
            this.binders.get(key).release();
        }
        this.binders.clear();
        this.binders = null;
    }

    @Override
    public BindingManager setDataUpdatedCallback(String propertyKey, DataUpdatedCallback callback) {
        if (this.binders.containsKey(propertyKey)) {
            this.binders.get(propertyKey).setDataUpdatedCallback(callback);
        }
        return this;
    }
}

