/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.application.EncodeRepresentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encoder
extends Filter {
    public static final int ENCODE_ALL_SIZES = -1;
    private volatile List<MediaType> acceptedMediaTypes;
    private volatile boolean encodeRequest;
    private volatile boolean encodeResponse;
    private volatile List<MediaType> ignoredMediaTypes;
    private volatile long mininumSize;

    public static List<MediaType> getDefaultAcceptedMediaTypes() {
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        result.add(MediaType.ALL);
        return result;
    }

    public static List<MediaType> getDefaultIgnoredMediaTypes() {
        List<MediaType> result = Arrays.asList(MediaType.APPLICATION_CAB, MediaType.APPLICATION_GNU_ZIP, MediaType.APPLICATION_ZIP, MediaType.APPLICATION_GNU_TAR, MediaType.APPLICATION_JAVA_ARCHIVE, MediaType.APPLICATION_STUFFIT, MediaType.APPLICATION_TAR, MediaType.AUDIO_ALL, MediaType.IMAGE_ALL, MediaType.VIDEO_ALL);
        return result;
    }

    public Encoder(Context context) {
        this(context, false, true, -1L, Encoder.getDefaultAcceptedMediaTypes(), Encoder.getDefaultIgnoredMediaTypes());
    }

    public Encoder(Context context, boolean encodeInput, boolean encodeOutput, long minimumSize, List<MediaType> acceptedMediaTypes, List<MediaType> ignoredMediaTypes) {
        super(context);
        this.encodeRequest = encodeInput;
        this.encodeResponse = encodeOutput;
        this.mininumSize = minimumSize;
        this.acceptedMediaTypes = acceptedMediaTypes;
        this.ignoredMediaTypes = ignoredMediaTypes;
    }

    public void afterHandle(Request request, Response response) {
        if (this.isEncodeResponse() && this.canEncode(response.getEntity())) {
            response.setEntity(this.encode(request.getClientInfo(), response.getEntity()));
        }
    }

    public int beforeHandle(Request request, Response response) {
        if (this.isEncodeRequest() && this.canEncode(request.getEntity())) {
            request.setEntity(this.encode(request.getClientInfo(), request.getEntity()));
        }
        return 0;
    }

    public boolean canEncode(Representation representation) {
        Iterator<MediaType> iter;
        boolean result = false;
        if (representation != null) {
            boolean identity = true;
            Iterator iter2 = representation.getEncodings().iterator();
            while (identity && iter2.hasNext()) {
                identity = ((Encoding)iter2.next()).equals((Object)Encoding.IDENTITY);
            }
            result = identity;
        }
        if (result) {
            boolean bl = result = this.getMinimumSize() == -1L || representation.getSize() == -1L || representation.getSize() >= this.getMinimumSize();
        }
        if (result) {
            MediaType mediaType = representation.getMediaType();
            boolean accepted = false;
            iter = this.getAcceptedMediaTypes().iterator();
            while (!accepted && iter.hasNext()) {
                accepted = iter.next().includes(mediaType);
            }
            result = accepted;
        }
        if (result) {
            MediaType mediaType = representation.getMediaType();
            boolean rejected = false;
            iter = this.getIgnoredMediaTypes().iterator();
            while (!rejected && iter.hasNext()) {
                rejected = iter.next().includes(mediaType);
            }
            result = !rejected;
        }
        return result;
    }

    public Representation encode(ClientInfo client, Representation representation) {
        Object result = representation;
        Encoding bestEncoding = this.getBestEncoding(client);
        if (bestEncoding != null) {
            result = new EncodeRepresentation(bestEncoding, representation);
        }
        return result;
    }

    public List<MediaType> getAcceptedMediaTypes() {
        return this.acceptedMediaTypes;
    }

    public Encoding getBestEncoding(ClientInfo client) {
        Encoding bestEncoding = null;
        Encoding currentEncoding2 = null;
        Preference currentPref2 = null;
        float bestScore = 0.0f;
        for (Encoding currentEncoding2 : EncodeRepresentation.getSupportedEncodings()) {
            for (Preference currentPref2 : client.getAcceptedEncodings()) {
                if (!((Encoding)currentPref2.getMetadata()).equals((Object)Encoding.ALL) && !((Encoding)currentPref2.getMetadata()).equals((Object)currentEncoding2) || !(currentPref2.getQuality() > bestScore)) continue;
                bestScore = currentPref2.getQuality();
                bestEncoding = currentEncoding2;
            }
        }
        return bestEncoding;
    }

    public List<MediaType> getIgnoredMediaTypes() {
        return this.ignoredMediaTypes;
    }

    public long getMinimumSize() {
        return this.mininumSize;
    }

    public boolean isEncodeRequest() {
        return this.encodeRequest;
    }

    public boolean isEncodeResponse() {
        return this.encodeResponse;
    }

    public void setEncodeRequest(boolean encodeRequest) {
        this.encodeRequest = encodeRequest;
    }

    public void setEncodeResponse(boolean encodeResponse) {
        this.encodeResponse = encodeResponse;
    }

    public void setMinimumSize(long mininumSize) {
        this.mininumSize = mininumSize;
    }
}

