/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.spring;

import com.noelios.restlet.ext.servlet.ServletConverter;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Restlet;
import org.springframework.beans.BeansException;
import org.springframework.web.servlet.FrameworkServlet;

public class RestletFrameworkServlet
extends FrameworkServlet {
    private static final String DEFAULT_TARGET_RESTLET_BEAN_NAME = "root";
    private static final long serialVersionUID = 1L;
    private volatile ServletConverter converter;
    private volatile String targetRestletBeanName;

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getConverter().service(request, response);
    }

    protected Restlet getTargetRestlet() {
        return (Restlet)this.getWebApplicationContext().getBean(this.getTargetRestletBeanName());
    }

    public String getTargetRestletBeanName() {
        return this.targetRestletBeanName == null ? DEFAULT_TARGET_RESTLET_BEAN_NAME : this.targetRestletBeanName;
    }

    protected ServletConverter getConverter() {
        return this.converter;
    }

    protected void initFrameworkServlet() throws ServletException, BeansException {
        Application application;
        super.initFrameworkServlet();
        this.converter = new ServletConverter(this.getServletContext());
        if (this.getTargetRestlet() instanceof Application) {
            application = (Application)this.getTargetRestlet();
        } else {
            application = new Application();
            application.setRoot(this.getTargetRestlet());
        }
        if (application.getContext() == null) {
            application.setContext(this.createContext());
        }
        this.converter.setTarget((Restlet)application);
    }

    protected Context createContext() {
        return new Context();
    }

    public void setTargetRestletBeanName(String targetRestletBeanName) {
        this.targetRestletBeanName = targetRestletBeanName;
    }
}

