/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.httpclient;

import com.noelios.restlet.ext.httpclient.HttpClientHelper;
import com.noelios.restlet.http.HttpClientCall;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.apache.commons.httpclient.ConnectMethod;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.util.Engine;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMethodCall
extends HttpClientCall {
    private volatile HttpClientHelper clientHelper;
    private volatile HttpMethod httpMethod;
    private volatile boolean responseHeadersAdded;

    public HttpMethodCall(HttpClientHelper helper, final String method, String requestUri, boolean hasEntity) throws IOException {
        super((com.noelios.restlet.http.HttpClientHelper)helper, method, requestUri);
        this.clientHelper = helper;
        if (requestUri.startsWith("http")) {
            if (method.equalsIgnoreCase(Method.GET.getName())) {
                this.httpMethod = new GetMethod(requestUri);
            } else if (method.equalsIgnoreCase(Method.POST.getName())) {
                this.httpMethod = new PostMethod(requestUri);
            } else if (method.equalsIgnoreCase(Method.PUT.getName())) {
                this.httpMethod = new PutMethod(requestUri);
            } else if (method.equalsIgnoreCase(Method.HEAD.getName())) {
                this.httpMethod = new HeadMethod(requestUri);
            } else if (method.equalsIgnoreCase(Method.DELETE.getName())) {
                this.httpMethod = new DeleteMethod(requestUri);
            } else if (method.equalsIgnoreCase(Method.CONNECT.getName())) {
                HostConfiguration host = new HostConfiguration();
                host.setHost(new URI(requestUri, false));
                this.httpMethod = new ConnectMethod(host);
            } else {
                this.httpMethod = method.equalsIgnoreCase(Method.OPTIONS.getName()) ? new OptionsMethod(requestUri) : (method.equalsIgnoreCase(Method.TRACE.getName()) ? new TraceMethod(requestUri) : new EntityEnclosingMethod(requestUri){

                    public String getName() {
                        return method;
                    }
                });
            }
            this.httpMethod.setFollowRedirects(this.clientHelper.isFollowRedirects());
            this.httpMethod.setDoAuthentication(false);
            if (this.clientHelper.getRetryHandler() != null) {
                try {
                    this.httpMethod.getParams().setParameter("http.method.retry-handler", Engine.loadClass((String)this.clientHelper.getRetryHandler()).newInstance());
                }
                catch (Exception e) {
                    this.clientHelper.getLogger().log(Level.WARNING, "An error occurred during the instantiation of the retry handler.", e);
                }
            }
        } else {
            throw new IllegalArgumentException("Only HTTP or HTTPS resource URIs are allowed here");
        }
        this.responseHeadersAdded = false;
        this.setConfidential(this.httpMethod.getURI().getScheme().equalsIgnoreCase(Protocol.HTTPS.getSchemeName()));
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getReasonPhrase() {
        return this.getHttpMethod().getStatusText();
    }

    public WritableByteChannel getRequestEntityChannel() {
        return null;
    }

    public OutputStream getRequestEntityStream() {
        return null;
    }

    public OutputStream getRequestHeadStream() {
        return null;
    }

    public ReadableByteChannel getResponseEntityChannel(long size) {
        return null;
    }

    public InputStream getResponseEntityStream(long size) {
        FilterInputStream result = null;
        try {
            InputStream responseBodyAsStream = this.getHttpMethod().getResponseBodyAsStream();
            if (responseBodyAsStream != null) {
                result = new FilterInputStream(responseBodyAsStream){

                    public void close() throws IOException {
                        super.close();
                        HttpMethodCall.this.getHttpMethod().releaseConnection();
                    }
                };
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return result;
    }

    public Series<Parameter> getResponseHeaders() {
        Series result = super.getResponseHeaders();
        if (!this.responseHeadersAdded) {
            for (Header header : this.getHttpMethod().getResponseHeaders()) {
                result.add(header.getName(), header.getValue());
            }
            this.responseHeadersAdded = true;
        }
        return result;
    }

    public String getServerAddress() {
        try {
            return this.getHttpMethod().getURI().getHost();
        }
        catch (URIException e) {
            return null;
        }
    }

    public int getStatusCode() {
        return this.getHttpMethod().getStatusCode();
    }

    public Status sendRequest(Request request) {
        Status result = null;
        try {
            final Representation entity = request.getEntity();
            for (Parameter header : this.getRequestHeaders()) {
                this.getHttpMethod().addRequestHeader(header.getName(), header.getValue());
            }
            if (entity != null && this.getHttpMethod() instanceof EntityEnclosingMethod) {
                EntityEnclosingMethod eem = (EntityEnclosingMethod)this.getHttpMethod();
                eem.setRequestEntity(new RequestEntity(){

                    public long getContentLength() {
                        return entity.getSize();
                    }

                    public String getContentType() {
                        return entity.getMediaType() != null ? entity.getMediaType().toString() : null;
                    }

                    public boolean isRepeatable() {
                        return !entity.isTransient();
                    }

                    public void writeRequest(OutputStream os) throws IOException {
                        entity.write(os);
                    }
                });
            }
            this.clientHelper.getHttpClient().executeMethod(this.getHttpMethod());
            result = new Status(this.getStatusCode(), null, this.getReasonPhrase(), null);
            if (this.getHttpMethod().getResponseBodyAsStream() == null) {
                this.getHttpMethod().releaseConnection();
            }
        }
        catch (IOException ioe) {
            this.clientHelper.getLogger().log(Level.WARNING, "An error occurred during the communication with the remote HTTP server.", ioe);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)ioe);
            this.getHttpMethod().releaseConnection();
        }
        return result;
    }
}

