/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import com.ning.compress.lzf.ChunkDecoder;
import com.ning.compress.lzf.util.ChunkDecoderFactory;
import java.io.IOException;

public class LZFDecoder {
    public static byte[] decode(byte[] inputBuffer) throws IOException {
        return LZFDecoder.decode(inputBuffer, 0, inputBuffer.length);
    }

    public static byte[] decode(byte[] inputBuffer, int offset, int length) throws IOException {
        return ChunkDecoderFactory.optimalInstance().decode(inputBuffer, offset, length);
    }

    public static int decode(byte[] inputBuffer, byte[] targetBuffer) throws IOException {
        return LZFDecoder.decode(inputBuffer, 0, inputBuffer.length, targetBuffer);
    }

    public static int decode(byte[] sourceBuffer, int offset, int length, byte[] targetBuffer) throws IOException {
        return ChunkDecoderFactory.optimalInstance().decode(sourceBuffer, offset, length, targetBuffer);
    }

    public static int calculateUncompressedSize(byte[] data, int offset, int length) throws IOException {
        return ChunkDecoder.calculateUncompressedSize(data, length, length);
    }
}

